/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.wrapper.classic;

import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.wrapper.XmlPullParserWrapper;
import org.xmlpull.v1.wrapper.XmlPullWrapperFactory;
import org.xmlpull.v1.wrapper.XmlSerializerWrapper;
import org.xmlpull.v1.wrapper.classic.XmlSerializerDelegate;

public class StaticXmlSerializerWrapper
extends XmlSerializerDelegate
implements XmlSerializerWrapper {
    private static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/features.html#xmldecl-standalone";
    private static final boolean TRACE_SIZING = false;
    protected String currentNs;
    protected XmlPullWrapperFactory wf;
    protected XmlPullParserWrapper fragmentParser;
    protected int namespaceEnd = 0;
    protected String[] namespacePrefix = new String[8];
    protected String[] namespaceUri = new String[this.namespacePrefix.length];
    protected int[] namespaceDepth = new int[this.namespacePrefix.length];

    public StaticXmlSerializerWrapper(XmlSerializer xmlSerializer, XmlPullWrapperFactory xmlPullWrapperFactory) {
        super(xmlSerializer);
        this.wf = xmlPullWrapperFactory;
    }

    public String getCurrentNamespaceForElements() {
        return this.currentNs;
    }

    public String setCurrentNamespaceForElements(String string) {
        String string2 = this.currentNs;
        this.currentNs = string;
        return string2;
    }

    public XmlSerializerWrapper attribute(String string, String string2) {
        this.xs.attribute(null, string, string2);
        return this;
    }

    public XmlSerializerWrapper startTag(String string) {
        this.xs.startTag(this.currentNs, string);
        return this;
    }

    public XmlSerializerWrapper endTag(String string) {
        StaticXmlSerializerWrapper staticXmlSerializerWrapper = this;
        staticXmlSerializerWrapper.endTag(staticXmlSerializerWrapper.currentNs, string);
        return this;
    }

    public XmlSerializerWrapper element(String string, String string2) {
        StaticXmlSerializerWrapper staticXmlSerializerWrapper = this;
        return staticXmlSerializerWrapper.element(staticXmlSerializerWrapper.currentNs, string, string2);
    }

    public XmlSerializerWrapper element(String string, String string2, String string3) {
        if (string2 == null) {
            throw new XmlPullParserException("name for element can not be null");
        }
        this.xs.startTag(string, string2);
        if (string3 == null) {
            this.xs.attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        } else {
            this.xs.text(string3);
        }
        this.xs.endTag(string, string2);
        return this;
    }

    private void ensureNamespacesCapacity() {
        int n2 = this.namespaceEnd > 7 ? 2 * this.namespaceEnd : 8;
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        int[] nArray = new int[n2];
        if (this.namespacePrefix != null) {
            System.arraycopy(this.namespacePrefix, 0, stringArray, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceUri, 0, stringArray2, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceDepth, 0, nArray, 0, this.namespaceEnd);
        }
        this.namespacePrefix = stringArray;
        this.namespaceUri = stringArray2;
        this.namespaceDepth = nArray;
    }

    public void setPrefix(String string, String string2) {
        this.xs.setPrefix(string, string2);
        int n2 = this.getDepth();
        for (int i2 = this.namespaceEnd - 1; i2 >= 0 && this.namespaceDepth[i2] > n2; --i2) {
            --this.namespaceEnd;
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string;
        this.namespaceUri[this.namespaceEnd] = string2;
        ++this.namespaceEnd;
    }

    public void fragment(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + this.namespaceEnd * 30);
        stringBuffer.append("<fragment");
        block0: for (int i2 = this.namespaceEnd - 1; i2 >= 0; --i2) {
            String string2 = this.namespacePrefix[i2];
            for (int i3 = this.namespaceEnd - 1; i3 > i2; --i3) {
                if (string2.equals(this.namespacePrefix[i3])) continue block0;
            }
            stringBuffer.append(" xmlns");
            if (string2.length() > 0) {
                stringBuffer.append(':').append(string2);
            }
            stringBuffer.append("='");
            StaticXmlSerializerWrapper staticXmlSerializerWrapper = this;
            stringBuffer.append(staticXmlSerializerWrapper.escapeAttributeValue(staticXmlSerializerWrapper.namespaceUri[i2]));
            stringBuffer.append("'");
        }
        stringBuffer.append(">");
        stringBuffer.append(string);
        stringBuffer.append("</fragment>");
        if (this.fragmentParser == null) {
            this.fragmentParser = this.wf.newPullParserWrapper();
        }
        String string3 = stringBuffer.toString();
        this.fragmentParser.setInput(new StringReader(string3));
        this.fragmentParser.nextTag();
        this.fragmentParser.require(2, null, "fragment");
        while (true) {
            this.fragmentParser.nextToken();
            if (this.fragmentParser.getDepth() == 1 && this.fragmentParser.getEventType() == 3) break;
            StaticXmlSerializerWrapper staticXmlSerializerWrapper = this;
            staticXmlSerializerWrapper.event(staticXmlSerializerWrapper.fragmentParser);
        }
        this.fragmentParser.require(3, null, "fragment");
    }

    public void event(XmlPullParser object) {
        int n2 = object.getEventType();
        switch (n2) {
            case 0: {
                Boolean bl = (Boolean)object.getProperty(PROPERTY_XMLDECL_STANDALONE);
                this.startDocument(object.getInputEncoding(), bl);
                return;
            }
            case 1: {
                this.endDocument();
                return;
            }
            case 2: {
                this.writeStartTag((XmlPullParser)object);
                return;
            }
            case 3: {
                this.endTag(object.getNamespace(), object.getName());
                return;
            }
            case 7: {
                object = object.getText();
                this.ignorableWhitespace((String)object);
                return;
            }
            case 4: {
                if (object.getDepth() > 0) {
                    this.text(object.getText());
                    return;
                }
                this.ignorableWhitespace(object.getText());
                return;
            }
            case 6: {
                this.entityRef(object.getName());
                return;
            }
            case 5: {
                this.cdsect(object.getText());
                return;
            }
            case 8: {
                this.processingInstruction(object.getText());
                return;
            }
            case 9: {
                this.comment(object.getText());
                return;
            }
            case 10: {
                this.docdecl(object.getText());
            }
        }
    }

    private void writeStartTag(XmlPullParser xmlPullParser) {
        int n2;
        if (!xmlPullParser.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes")) {
            XmlPullParser xmlPullParser2 = xmlPullParser;
            n2 = xmlPullParser2.getNamespaceCount(xmlPullParser2.getDepth() - 1);
            XmlPullParser xmlPullParser3 = xmlPullParser;
            int n3 = xmlPullParser3.getNamespaceCount(xmlPullParser3.getDepth());
            while (n2 < n3) {
                String string = xmlPullParser.getNamespacePrefix(n2);
                String string2 = xmlPullParser.getNamespaceUri(n2);
                ((XmlSerializerDelegate)this).setPrefix(string, string2);
                ++n2;
            }
        }
        this.startTag(xmlPullParser.getNamespace(), xmlPullParser.getName());
        for (n2 = 0; n2 < xmlPullParser.getAttributeCount(); ++n2) {
            this.attribute(xmlPullParser.getAttributeNamespace(n2), xmlPullParser.getAttributeName(n2), xmlPullParser.getAttributeValue(n2));
        }
    }

    public String escapeAttributeValue(String string) {
        int n2 = string.indexOf(60);
        int n3 = string.indexOf(38);
        int n4 = string.indexOf(34);
        int c2 = string.indexOf(39);
        if (n2 == -1 && n3 == -1 && n4 == -1 && c2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        n4 = string.length();
        block6: for (n3 = 0; n3 < n4; ++n3) {
            char c3 = string.charAt(n3);
            switch (c3) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c3);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String escapeText(String string) {
        int n2;
        StringBuffer stringBuffer;
        block5: {
            int n3 = string.indexOf(60);
            int n4 = string.indexOf(38);
            if (n3 == -1 && n4 == -1) {
                return string;
            }
            stringBuffer = new StringBuffer(string.length() + 10);
            n2 = 0;
            while (true) {
                if (n3 == -1 && n4 == -1) break block5;
                if (n3 == -1 || n3 != -1 && n4 != -1 && n4 < n3) {
                    if (n2 < n4) {
                        stringBuffer.append(string.substring(n2, n4));
                    }
                    stringBuffer.append("&amp;");
                    n2 = n4 + 1;
                    n4 = string.indexOf(38, n2);
                    continue;
                }
                if (n4 != -1 && (n3 == -1 || n4 == -1 || n3 >= n4)) break;
                if (n2 < n3) {
                    stringBuffer.append(string.substring(n2, n3));
                }
                stringBuffer.append("&lt;");
                n2 = n3 + 1;
                n3 = string.indexOf(60, n2);
            }
            throw new IllegalStateException("wrong state posLt=" + n3 + " posAmp=" + n4 + " for " + string);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public void writeDouble(double d2) {
        if (d2 == Double.POSITIVE_INFINITY) {
            this.xs.text("INF");
            return;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            this.xs.text("-INF");
            return;
        }
        this.xs.text(Double.toString(d2));
    }

    public void writeFloat(float f2) {
        if (f2 == Float.POSITIVE_INFINITY) {
            this.xs.text("INF");
            return;
        }
        if (f2 == Float.NEGATIVE_INFINITY) {
            this.xs.text("-INF");
            return;
        }
        this.xs.text(Float.toString(f2));
    }

    public void writeInt(int n2) {
        this.xs.text(Integer.toString(n2));
    }

    public void writeString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string can not be written");
        }
        this.xs.text(string);
    }

    public void writeDoubleElement(String string, String string2, double d2) {
        this.xs.startTag(string, string2);
        this.writeDouble(d2);
        this.xs.endTag(string, string2);
    }

    public void writeFloatElement(String string, String string2, float f2) {
        this.xs.startTag(string, string2);
        this.writeFloat(f2);
        this.xs.endTag(string, string2);
    }

    public void writeIntElement(String string, String string2, int n2) {
        this.xs.startTag(string, string2);
        this.writeInt(n2);
        this.xs.endTag(string, string2);
    }

    public void writeStringElement(String string, String string2, String string3) {
        this.xs.startTag(string, string2);
        if (string3 == null) {
            this.xs.attribute("http://www.w3.org/2001/XMLSchema", "nil", "true");
        } else {
            this.writeString(string3);
        }
        this.xs.endTag(string, string2);
    }
}

