/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.DumperOptions$FlowStyle;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml$1;
import org.yaml.snakeyaml.Yaml$2;
import org.yaml.snakeyaml.Yaml$3;
import org.yaml.snakeyaml.Yaml$EventIterable;
import org.yaml.snakeyaml.Yaml$NodeIterable;
import org.yaml.snakeyaml.Yaml$SilentEmitter;
import org.yaml.snakeyaml.Yaml$YamlIterable;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.BaseRepresenter;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

public class Yaml {
    protected final Resolver resolver;
    private String name;
    protected BaseConstructor constructor;
    protected Representer representer;
    protected DumperOptions dumperOptions;
    protected LoaderOptions loadingConfig;

    public Yaml() {
        this(new Constructor(), new Representer(), new DumperOptions(), new LoaderOptions(), new Resolver());
    }

    public Yaml(DumperOptions dumperOptions) {
        this(new Constructor(), new Representer(dumperOptions), dumperOptions);
    }

    public Yaml(LoaderOptions loaderOptions) {
        this((BaseConstructor)new Constructor(loaderOptions), new Representer(), new DumperOptions(), loaderOptions);
    }

    public Yaml(Representer representer) {
        this(new Constructor(), representer);
    }

    public Yaml(BaseConstructor baseConstructor) {
        this(baseConstructor, new Representer());
    }

    public Yaml(BaseConstructor baseConstructor, Representer representer) {
        Representer representer2 = representer;
        this(baseConstructor, representer2, Yaml.initDumperOptions(representer2));
    }

    private static DumperOptions initDumperOptions(Representer representer) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(representer.getDefaultFlowStyle());
        dumperOptions.setDefaultScalarStyle(representer.getDefaultScalarStyle());
        dumperOptions.setAllowReadOnlyProperties(representer.getPropertyUtils().isAllowReadOnlyProperties());
        dumperOptions.setTimeZone(representer.getTimeZone());
        return dumperOptions;
    }

    public Yaml(Representer representer, DumperOptions dumperOptions) {
        this(new Constructor(), representer, dumperOptions, new LoaderOptions(), new Resolver());
    }

    public Yaml(BaseConstructor baseConstructor, Representer representer, DumperOptions dumperOptions) {
        this(baseConstructor, representer, dumperOptions, new LoaderOptions(), new Resolver());
    }

    public Yaml(BaseConstructor baseConstructor, Representer representer, DumperOptions dumperOptions, LoaderOptions loaderOptions) {
        this(baseConstructor, representer, dumperOptions, loaderOptions, new Resolver());
    }

    public Yaml(BaseConstructor baseConstructor, Representer representer, DumperOptions dumperOptions, Resolver resolver) {
        this(baseConstructor, representer, dumperOptions, new LoaderOptions(), resolver);
    }

    public Yaml(BaseConstructor baseConstructor, Representer representer, DumperOptions dumperOptions, LoaderOptions loaderOptions, Resolver resolver) {
        if (!baseConstructor.isExplicitPropertyUtils()) {
            baseConstructor.setPropertyUtils(representer.getPropertyUtils());
        } else if (!representer.isExplicitPropertyUtils()) {
            ((BaseRepresenter)representer).setPropertyUtils(baseConstructor.getPropertyUtils());
        }
        this.constructor = baseConstructor;
        this.constructor.setAllowDuplicateKeys(loaderOptions.isAllowDuplicateKeys());
        this.constructor.setWrappedToRootException(loaderOptions.isWrappedToRootException());
        if (!dumperOptions.getIndentWithIndicator() && dumperOptions.getIndent() <= dumperOptions.getIndicatorIndent()) {
            throw new YAMLException("Indicator indent must be smaller then indent.");
        }
        representer.setDefaultFlowStyle(dumperOptions.getDefaultFlowStyle());
        representer.setDefaultScalarStyle(dumperOptions.getDefaultScalarStyle());
        representer.getPropertyUtils().setAllowReadOnlyProperties(dumperOptions.isAllowReadOnlyProperties());
        representer.setTimeZone(dumperOptions.getTimeZone());
        this.representer = representer;
        this.dumperOptions = dumperOptions;
        this.loadingConfig = loaderOptions;
        this.resolver = resolver;
        this.name = "Yaml:" + System.identityHashCode(this);
    }

    public String dump(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        return this.dumpAll(arrayList.iterator());
    }

    public Node represent(Object object) {
        return this.representer.represent(object);
    }

    public String dumpAll(Iterator<? extends Object> iterator) {
        StringWriter stringWriter = new StringWriter();
        this.dumpAll(iterator, stringWriter, null);
        return stringWriter.toString();
    }

    public void dump(Object object, Writer writer) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        this.dumpAll(arrayList.iterator(), writer, null);
    }

    public void dumpAll(Iterator<? extends Object> iterator, Writer writer) {
        this.dumpAll(iterator, writer, null);
    }

    private void dumpAll(Iterator<? extends Object> iterator, Writer object, Tag object2) {
        object = new Serializer(new Emitter((Writer)object, this.dumperOptions), this.resolver, this.dumperOptions, (Tag)object2);
        try {
            ((Serializer)object).open();
            while (iterator.hasNext()) {
                object2 = this.representer.represent(iterator.next());
                ((Serializer)object).serialize((Node)object2);
            }
            ((Serializer)object).close();
            return;
        }
        catch (IOException iOException) {
            throw new YAMLException(iOException);
        }
    }

    public String dumpAs(Object object, Tag tag, DumperOptions$FlowStyle object2) {
        DumperOptions$FlowStyle dumperOptions$FlowStyle = this.representer.getDefaultFlowStyle();
        if (object2 != null) {
            this.representer.setDefaultFlowStyle((DumperOptions$FlowStyle)((Object)object2));
        }
        object2 = new ArrayList<Object>(1);
        object2.add(object);
        object = new StringWriter();
        this.dumpAll(object2.iterator(), (Writer)object, tag);
        this.representer.setDefaultFlowStyle(dumperOptions$FlowStyle);
        return ((StringWriter)object).toString();
    }

    public String dumpAsMap(Object object) {
        return this.dumpAs(object, Tag.MAP, DumperOptions$FlowStyle.BLOCK);
    }

    public void serialize(Node node, Writer object) {
        object = new Serializer(new Emitter((Writer)object, this.dumperOptions), this.resolver, this.dumperOptions, null);
        try {
            ((Serializer)object).open();
            ((Serializer)object).serialize(node);
            ((Serializer)object).close();
            return;
        }
        catch (IOException iOException) {
            throw new YAMLException(iOException);
        }
    }

    public List<Event> serialize(Node node) {
        Yaml$SilentEmitter yaml$SilentEmitter = new Yaml$SilentEmitter(null);
        Serializer serializer = new Serializer(yaml$SilentEmitter, this.resolver, this.dumperOptions, null);
        try {
            serializer.open();
            serializer.serialize(node);
            serializer.close();
        }
        catch (IOException iOException) {
            throw new YAMLException(iOException);
        }
        return yaml$SilentEmitter.getEvents();
    }

    public <T> T load(String string) {
        return (T)this.loadFromReader(new StreamReader(string), Object.class);
    }

    public <T> T load(InputStream inputStream) {
        return (T)this.loadFromReader(new StreamReader(new UnicodeReader(inputStream)), Object.class);
    }

    public <T> T load(Reader reader) {
        return (T)this.loadFromReader(new StreamReader(reader), Object.class);
    }

    public <T> T loadAs(Reader reader, Class<T> clazz) {
        return (T)this.loadFromReader(new StreamReader(reader), clazz);
    }

    public <T> T loadAs(String string, Class<T> clazz) {
        return (T)this.loadFromReader(new StreamReader(string), clazz);
    }

    public <T> T loadAs(InputStream inputStream, Class<T> clazz) {
        return (T)this.loadFromReader(new StreamReader(new UnicodeReader(inputStream)), clazz);
    }

    private Object loadFromReader(StreamReader object, Class<?> clazz) {
        object = new Composer(new ParserImpl((StreamReader)object, this.loadingConfig.isProcessComments()), this.resolver, this.loadingConfig);
        this.constructor.setComposer((Composer)object);
        return this.constructor.getSingleData(clazz);
    }

    public Iterable<Object> loadAll(Reader object) {
        object = new Composer(new ParserImpl(new StreamReader((Reader)object), this.loadingConfig.isProcessComments()), this.resolver, this.loadingConfig);
        this.constructor.setComposer((Composer)object);
        object = new Yaml$1(this);
        return new Yaml$YamlIterable((Iterator<Object>)object);
    }

    public Iterable<Object> loadAll(String string) {
        return this.loadAll(new StringReader(string));
    }

    public Iterable<Object> loadAll(InputStream inputStream) {
        return this.loadAll(new UnicodeReader(inputStream));
    }

    public Node compose(Reader object) {
        object = new Composer(new ParserImpl(new StreamReader((Reader)object), this.loadingConfig.isProcessComments()), this.resolver, this.loadingConfig);
        return ((Composer)object).getSingleNode();
    }

    public Iterable<Node> composeAll(Reader object) {
        object = new Composer(new ParserImpl(new StreamReader((Reader)object), this.loadingConfig.isProcessComments()), this.resolver, this.loadingConfig);
        object = new Yaml$2(this, (Composer)object);
        return new Yaml$NodeIterable((Iterator<Node>)object);
    }

    public void addImplicitResolver(Tag tag, Pattern pattern, String string) {
        this.resolver.addImplicitResolver(tag, pattern, string);
    }

    public void addImplicitResolver(Tag tag, Pattern pattern, String string, int n2) {
        this.resolver.addImplicitResolver(tag, pattern, string, n2);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Iterable<Event> parse(Reader object) {
        object = new ParserImpl(new StreamReader((Reader)object), this.loadingConfig.isProcessComments());
        object = new Yaml$3(this, (Parser)object);
        return new Yaml$EventIterable((Iterator<Event>)object);
    }

    public void setBeanAccess(BeanAccess beanAccess) {
        this.constructor.getPropertyUtils().setBeanAccess(beanAccess);
        this.representer.getPropertyUtils().setBeanAccess(beanAccess);
    }

    public void addTypeDescription(TypeDescription typeDescription) {
        this.constructor.addTypeDescription(typeDescription);
        this.representer.addTypeDescription(typeDescription);
    }
}

