/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.comments;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.yaml.snakeyaml.comments.CommentEventsCollector$1;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.events.CommentEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.Event$ID;
import org.yaml.snakeyaml.parser.Parser;

public class CommentEventsCollector {
    private List<CommentLine> commentLineList;
    private Queue<Event> eventSource;
    private CommentType[] expectedCommentTypes;

    public CommentEventsCollector(Parser parser, CommentType ... commentTypeArray) {
        this.eventSource = new CommentEventsCollector$1(this, parser);
        this.expectedCommentTypes = commentTypeArray;
        this.commentLineList = new ArrayList<CommentLine>();
    }

    public CommentEventsCollector(Queue<Event> queue, CommentType ... commentTypeArray) {
        this.eventSource = queue;
        this.expectedCommentTypes = commentTypeArray;
        this.commentLineList = new ArrayList<CommentLine>();
    }

    private boolean isEventExpected(Event event) {
        if (event == null || !event.is(Event$ID.Comment)) {
            return false;
        }
        event = (CommentEvent)event;
        CommentType[] commentTypeArray = this.expectedCommentTypes;
        int n2 = this.expectedCommentTypes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CommentType commentType = commentTypeArray[i2];
            if (((CommentEvent)event).getCommentType() != commentType) continue;
            return true;
        }
        return false;
    }

    public CommentEventsCollector collectEvents() {
        this.collectEvents(null);
        return this;
    }

    public Event collectEvents(Event event) {
        if (event != null) {
            if (this.isEventExpected(event)) {
                this.commentLineList.add(new CommentLine((CommentEvent)event));
            } else {
                return event;
            }
        }
        while (true) {
            CommentEventsCollector commentEventsCollector = this;
            if (!commentEventsCollector.isEventExpected(commentEventsCollector.eventSource.peek())) break;
            this.commentLineList.add(new CommentLine((CommentEvent)this.eventSource.poll()));
        }
        return null;
    }

    public Event collectEventsAndPoll(Event event) {
        if ((event = this.collectEvents(event)) != null) {
            return event;
        }
        return this.eventSource.poll();
    }

    public List<CommentLine> consume() {
        try {
            List<CommentLine> list = this.commentLineList;
            return list;
        }
        finally {
            this.commentLineList = new ArrayList<CommentLine>();
        }
    }

    public boolean isEmpty() {
        return this.commentLineList.isEmpty();
    }
}

