/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.composer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions$FlowStyle;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.comments.CommentEventsCollector;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.composer.ComposerException;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.Event$ID;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.resolver.Resolver;

public class Composer {
    protected final Parser parser;
    private final Resolver resolver;
    private final Map<String, Node> anchors;
    private final Set<Node> recursiveNodes;
    private int nonScalarAliasesCount = 0;
    private final LoaderOptions loadingConfig;
    private final CommentEventsCollector blockCommentsCollector;
    private final CommentEventsCollector inlineCommentsCollector;
    private int nestingDepth = 0;
    private final int nestingDepthLimit;

    public Composer(Parser parser, Resolver resolver) {
        this(parser, resolver, new LoaderOptions());
    }

    public Composer(Parser parser, Resolver resolver, LoaderOptions loaderOptions) {
        this.parser = parser;
        this.resolver = resolver;
        this.anchors = new HashMap<String, Node>();
        this.recursiveNodes = new HashSet<Node>();
        this.loadingConfig = loaderOptions;
        this.blockCommentsCollector = new CommentEventsCollector(parser, CommentType.BLANK_LINE, CommentType.BLOCK);
        this.inlineCommentsCollector = new CommentEventsCollector(parser, CommentType.IN_LINE);
        this.nestingDepthLimit = loaderOptions.getNestingDepthLimit();
    }

    public boolean checkNode() {
        if (this.parser.checkEvent(Event$ID.StreamStart)) {
            this.parser.getEvent();
        }
        return !this.parser.checkEvent(Event$ID.StreamEnd);
    }

    public Node getNode() {
        this.blockCommentsCollector.collectEvents();
        if (this.parser.checkEvent(Event$ID.StreamEnd)) {
            List<CommentLine> list = this.blockCommentsCollector.consume();
            Object object = list.get(0).getStartMark();
            List<NodeTuple> list2 = Collections.emptyList();
            object = new MappingNode(Tag.COMMENT, false, list2, (Mark)object, null, DumperOptions$FlowStyle.BLOCK);
            ((Node)object).setBlockComments(list);
            return object;
        }
        this.parser.getEvent();
        Node node = this.composeNode(null);
        this.blockCommentsCollector.collectEvents();
        if (!this.blockCommentsCollector.isEmpty()) {
            node.setEndComments(this.blockCommentsCollector.consume());
        }
        this.parser.getEvent();
        this.anchors.clear();
        this.recursiveNodes.clear();
        return node;
    }

    public Node getSingleNode() {
        this.parser.getEvent();
        Object object = null;
        if (!this.parser.checkEvent(Event$ID.StreamEnd)) {
            object = this.getNode();
        }
        if (!this.parser.checkEvent(Event$ID.StreamEnd)) {
            Event event = this.parser.getEvent();
            object = object != null ? ((Node)object).getStartMark() : null;
            throw new ComposerException("expected a single document in the stream", (Mark)object, "but found another document", event.getStartMark());
        }
        this.parser.getEvent();
        return object;
    }

    private Node composeNode(Node node) {
        Object object;
        this.blockCommentsCollector.collectEvents();
        if (node != null) {
            this.recursiveNodes.add(node);
        }
        if (this.parser.checkEvent(Event$ID.Alias)) {
            object = (AliasEvent)this.parser.getEvent();
            String string = ((NodeEvent)object).getAnchor();
            if (!this.anchors.containsKey(string)) {
                throw new ComposerException(null, null, "found undefined alias " + string, ((Event)object).getStartMark());
            }
            object = this.anchors.get(string);
            if (!(object instanceof ScalarNode)) {
                ++this.nonScalarAliasesCount;
                if (this.nonScalarAliasesCount > this.loadingConfig.getMaxAliasesForCollections()) {
                    throw new YAMLException("Number of aliases for non-scalar nodes exceeds the specified max=" + this.loadingConfig.getMaxAliasesForCollections());
                }
            }
            if (this.recursiveNodes.remove(object)) {
                ((Node)object).setTwoStepsConstruction(true);
            }
            this.blockCommentsCollector.consume();
            this.inlineCommentsCollector.collectEvents().consume();
        } else {
            object = (NodeEvent)this.parser.peekEvent();
            String string = ((NodeEvent)object).getAnchor();
            this.increaseNestingDepth();
            object = this.parser.checkEvent(Event$ID.Scalar) ? this.composeScalarNode(string, this.blockCommentsCollector.consume()) : (this.parser.checkEvent(Event$ID.SequenceStart) ? this.composeSequenceNode(string) : this.composeMappingNode(string));
            this.decreaseNestingDepth();
        }
        this.recursiveNodes.remove(node);
        return object;
    }

    protected Node composeScalarNode(String string, List<CommentLine> list) {
        Object object = (ScalarEvent)this.parser.getEvent();
        Object object2 = ((ScalarEvent)object).getTag();
        boolean bl = false;
        if (object2 == null || ((String)object2).equals("!")) {
            object2 = this.resolver.resolve(NodeId.scalar, ((ScalarEvent)object).getValue(), ((ScalarEvent)object).getImplicit().canOmitTagInPlainScalar());
            bl = true;
        } else {
            object2 = new Tag((String)object2);
        }
        object = new ScalarNode((Tag)object2, bl, ((ScalarEvent)object).getValue(), ((Event)object).getStartMark(), ((Event)object).getEndMark(), ((ScalarEvent)object).getScalarStyle());
        if (string != null) {
            ((Node)object).setAnchor(string);
            this.anchors.put(string, (Node)object);
        }
        ((Node)object).setBlockComments(list);
        ((Node)object).setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        return object;
    }

    protected Node composeSequenceNode(String object) {
        SequenceStartEvent sequenceStartEvent = (SequenceStartEvent)this.parser.getEvent();
        Object object2 = sequenceStartEvent.getTag();
        boolean bl = false;
        if (object2 == null || ((String)object2).equals("!")) {
            object2 = this.resolver.resolve(NodeId.sequence, null, sequenceStartEvent.getImplicit());
            bl = true;
        } else {
            object2 = new Tag((String)object2);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        object2 = new SequenceNode((Tag)object2, bl, arrayList, sequenceStartEvent.getStartMark(), null, sequenceStartEvent.getFlowStyle());
        if (sequenceStartEvent.isFlow()) {
            ((Node)object2).setBlockComments(this.blockCommentsCollector.consume());
        }
        if (object != null) {
            ((Node)object2).setAnchor((String)object);
            this.anchors.put((String)object, (Node)object2);
        }
        while (!this.parser.checkEvent(Event$ID.SequenceEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event$ID.SequenceEnd)) break;
            arrayList.add(this.composeNode((Node)object2));
        }
        if (sequenceStartEvent.isFlow()) {
            ((Node)object2).setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        }
        object = this.parser.getEvent();
        ((CollectionNode)object2).setEndMark(((Event)object).getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            ((Node)object2).setInLineComments(this.inlineCommentsCollector.consume());
        }
        return object2;
    }

    protected Node composeMappingNode(String object) {
        MappingStartEvent mappingStartEvent = (MappingStartEvent)this.parser.getEvent();
        Object object2 = mappingStartEvent.getTag();
        boolean bl = false;
        if (object2 == null || ((String)object2).equals("!")) {
            object2 = this.resolver.resolve(NodeId.mapping, null, mappingStartEvent.getImplicit());
            bl = true;
        } else {
            object2 = new Tag((String)object2);
        }
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>();
        object2 = new MappingNode((Tag)object2, bl, arrayList, mappingStartEvent.getStartMark(), null, mappingStartEvent.getFlowStyle());
        if (mappingStartEvent.isFlow()) {
            ((Node)object2).setBlockComments(this.blockCommentsCollector.consume());
        }
        if (object != null) {
            ((Node)object2).setAnchor((String)object);
            this.anchors.put((String)object, (Node)object2);
        }
        while (!this.parser.checkEvent(Event$ID.MappingEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event$ID.MappingEnd)) break;
            this.composeMappingChildren(arrayList, (MappingNode)object2);
        }
        if (mappingStartEvent.isFlow()) {
            ((Node)object2).setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        }
        object = this.parser.getEvent();
        ((CollectionNode)object2).setEndMark(((Event)object).getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            ((Node)object2).setInLineComments(this.inlineCommentsCollector.consume());
        }
        return object2;
    }

    protected void composeMappingChildren(List<NodeTuple> list, MappingNode node) {
        Node node2 = this.composeKeyNode((MappingNode)node);
        if (node2.getTag().equals(Tag.MERGE)) {
            node.setMerged(true);
        }
        node = this.composeValueNode((MappingNode)node);
        list.add(new NodeTuple(node2, node));
    }

    protected Node composeKeyNode(MappingNode mappingNode) {
        return this.composeNode(mappingNode);
    }

    protected Node composeValueNode(MappingNode mappingNode) {
        return this.composeNode(mappingNode);
    }

    private void increaseNestingDepth() {
        if (this.nestingDepth > this.nestingDepthLimit) {
            throw new YAMLException("Nesting Depth exceeded max " + this.nestingDepthLimit);
        }
        ++this.nestingDepth;
    }

    private void decreaseNestingDepth() {
        if (this.nestingDepth > 0) {
            --this.nestingDepth;
            return;
        }
        throw new YAMLException("Nesting Depth cannot be negative");
    }
}

