/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.BaseConstructor$RecursiveTuple;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public abstract class BaseConstructor {
    protected static final Object NOT_INSTANTIATED_OBJECT = new Object();
    protected final Map<NodeId, Construct> yamlClassConstructors = new EnumMap<NodeId, Construct>(NodeId.class);
    public final Map<Tag, Construct> yamlConstructors = new HashMap<Tag, Construct>();
    protected final Map<String, Construct> yamlMultiConstructors = new HashMap<String, Construct>();
    protected Composer composer;
    final Map<Node, Object> constructedObjects = new HashMap<Node, Object>();
    private final Set<Node> recursiveObjects = new HashSet<Node>();
    private final ArrayList<BaseConstructor$RecursiveTuple<Map<Object, Object>, BaseConstructor$RecursiveTuple<Object, Object>>> maps2fill = new ArrayList();
    private final ArrayList<BaseConstructor$RecursiveTuple<Set<Object>, Object>> sets2fill = new ArrayList();
    protected Tag rootTag = null;
    private PropertyUtils propertyUtils;
    private boolean explicitPropertyUtils = false;
    private boolean allowDuplicateKeys = true;
    private boolean wrappedToRootException = false;
    private boolean enumCaseSensitive = false;
    protected final Map<Class<? extends Object>, TypeDescription> typeDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();
    protected final Map<Tag, Class<? extends Object>> typeTags = new HashMap<Tag, Class<? extends Object>>();
    protected LoaderOptions loadingConfig;

    public BaseConstructor() {
        this(new LoaderOptions());
    }

    public BaseConstructor(LoaderOptions loaderOptions) {
        this.typeDefinitions.put(SortedMap.class, new TypeDescription(SortedMap.class, Tag.OMAP, TreeMap.class));
        this.typeDefinitions.put(SortedSet.class, new TypeDescription(SortedSet.class, Tag.SET, TreeSet.class));
        this.loadingConfig = loaderOptions;
    }

    public void setComposer(Composer composer) {
        this.composer = composer;
    }

    public boolean checkData() {
        return this.composer.checkNode();
    }

    public Object getData() {
        if (!this.composer.checkNode()) {
            throw new NoSuchElementException("No document is available.");
        }
        Node node = this.composer.getNode();
        if (this.rootTag != null) {
            node.setTag(this.rootTag);
        }
        return this.constructDocument(node);
    }

    public Object getSingleData(Class<?> object) {
        Node node = this.composer.getSingleNode();
        if (node != null && !Tag.NULL.equals(node.getTag())) {
            if (Object.class != object) {
                node.setTag(new Tag((Class<? extends Object>)object));
            } else if (this.rootTag != null) {
                node.setTag(this.rootTag);
            }
            return this.constructDocument(node);
        }
        object = this.yamlConstructors.get(Tag.NULL);
        return object.construct(node);
    }

    protected final Object constructDocument(Node object) {
        try {
            object = this.constructObject((Node)object);
            this.fillRecursive();
            return object;
        }
        catch (RuntimeException runtimeException) {
            if (this.wrappedToRootException && !(runtimeException instanceof YAMLException)) {
                throw new YAMLException(runtimeException);
            }
            throw runtimeException;
        }
        finally {
            this.constructedObjects.clear();
            this.recursiveObjects.clear();
        }
    }

    private void fillRecursive() {
        if (!this.maps2fill.isEmpty()) {
            for (BaseConstructor$RecursiveTuple<Map<Object, Object>, BaseConstructor$RecursiveTuple<Object, Object>> baseConstructor$RecursiveTuple : this.maps2fill) {
                BaseConstructor$RecursiveTuple<Object, Object> baseConstructor$RecursiveTuple2 = baseConstructor$RecursiveTuple._2();
                baseConstructor$RecursiveTuple._1().put(baseConstructor$RecursiveTuple2._1(), baseConstructor$RecursiveTuple2._2());
            }
            this.maps2fill.clear();
        }
        if (!this.sets2fill.isEmpty()) {
            for (BaseConstructor$RecursiveTuple<Object, Object> baseConstructor$RecursiveTuple : this.sets2fill) {
                ((Set)baseConstructor$RecursiveTuple._1()).add(baseConstructor$RecursiveTuple._2());
            }
            this.sets2fill.clear();
        }
    }

    protected Object constructObject(Node node) {
        if (this.constructedObjects.containsKey(node)) {
            return this.constructedObjects.get(node);
        }
        return this.constructObjectNoCheck(node);
    }

    protected Object constructObjectNoCheck(Node node) {
        if (this.recursiveObjects.contains(node)) {
            throw new ConstructorException(null, null, "found unconstructable recursive node", node.getStartMark());
        }
        this.recursiveObjects.add(node);
        Construct construct = this.getConstructor(node);
        Object object = this.constructedObjects.containsKey(node) ? this.constructedObjects.get(node) : construct.construct(node);
        this.finalizeConstruction(node, object);
        this.constructedObjects.put(node, object);
        this.recursiveObjects.remove(node);
        if (node.isTwoStepsConstruction()) {
            construct.construct2ndStep(node, object);
        }
        return object;
    }

    public Construct getConstructor(Node node) {
        if (node.useClassConstructor()) {
            return this.yamlClassConstructors.get((Object)node.getNodeId());
        }
        Construct construct = this.yamlConstructors.get(node.getTag());
        if (construct == null) {
            for (String string : this.yamlMultiConstructors.keySet()) {
                if (!node.getTag().startsWith(string)) continue;
                return this.yamlMultiConstructors.get(string);
            }
            return this.yamlConstructors.get(null);
        }
        return construct;
    }

    public String constructScalar(ScalarNode scalarNode) {
        return scalarNode.getValue();
    }

    protected List<Object> createDefaultList(int n2) {
        return new ArrayList<Object>(n2);
    }

    protected Set<Object> createDefaultSet(int n2) {
        return new LinkedHashSet<Object>(n2);
    }

    protected Map<Object, Object> createDefaultMap(int n2) {
        return new LinkedHashMap<Object, Object>(n2);
    }

    protected Object createArray(Class<?> clazz, int n2) {
        return Array.newInstance(clazz.getComponentType(), n2);
    }

    protected Object finalizeConstruction(Node object, Object object2) {
        if (this.typeDefinitions.containsKey(object = ((Node)object).getType())) {
            return this.typeDefinitions.get(object).finalizeConstruction(object2);
        }
        return object2;
    }

    protected Object newInstance(Node node) {
        return this.newInstance(Object.class, node);
    }

    protected final Object newInstance(Class<?> clazz, Node node) {
        return this.newInstance(clazz, node, true);
    }

    protected Object newInstance(Class<?> clazz, Node object, boolean bl) {
        try {
            Object object2;
            Class<? extends Object> clazz2 = ((Node)object).getType();
            if (this.typeDefinitions.containsKey(clazz2) && (object = ((TypeDescription)(object2 = this.typeDefinitions.get(clazz2))).newInstance((Node)object)) != null) {
                return object;
            }
            if (bl && clazz.isAssignableFrom(clazz2) && !Modifier.isAbstract(clazz2.getModifiers())) {
                object2 = clazz2.getDeclaredConstructor(new Class[0]);
                ((Constructor)object2).setAccessible(true);
                return ((Constructor)object2).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            throw new YAMLException(exception);
        }
        return NOT_INSTANTIATED_OBJECT;
    }

    protected Set<Object> newSet(CollectionNode<?> collectionNode) {
        Object object = this.newInstance(Set.class, collectionNode);
        if (object != NOT_INSTANTIATED_OBJECT) {
            return (Set)object;
        }
        return this.createDefaultSet(collectionNode.getValue().size());
    }

    protected List<Object> newList(SequenceNode sequenceNode) {
        Object object = this.newInstance(List.class, sequenceNode);
        if (object != NOT_INSTANTIATED_OBJECT) {
            return (List)object;
        }
        return this.createDefaultList(((CollectionNode)sequenceNode).getValue().size());
    }

    protected Map<Object, Object> newMap(MappingNode mappingNode) {
        Object object = this.newInstance(Map.class, mappingNode);
        if (object != NOT_INSTANTIATED_OBJECT) {
            return (Map)object;
        }
        return this.createDefaultMap(((CollectionNode)mappingNode).getValue().size());
    }

    public List<? extends Object> constructSequence(SequenceNode sequenceNode) {
        List<Object> list = this.newList(sequenceNode);
        this.constructSequenceStep2(sequenceNode, list);
        return list;
    }

    protected Set<? extends Object> constructSet(SequenceNode sequenceNode) {
        Set<Object> set = this.newSet(sequenceNode);
        this.constructSequenceStep2(sequenceNode, set);
        return set;
    }

    protected Object constructArray(SequenceNode sequenceNode) {
        return this.constructArrayStep2(sequenceNode, this.createArray(sequenceNode.getType(), ((CollectionNode)sequenceNode).getValue().size()));
    }

    protected void constructSequenceStep2(SequenceNode object, Collection<Object> collection) {
        for (Node node : ((CollectionNode)object).getValue()) {
            collection.add(this.constructObject(node));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object constructArrayStep2(SequenceNode iterator, Object object) {
        Class<?> clazz = ((Node)((Object)iterator)).getType().getComponentType();
        int n2 = 0;
        for (Node node : ((CollectionNode)((Object)iterator)).getValue()) {
            if (node.getType() == Object.class) {
                node.setType(clazz);
            }
            Object object2 = this.constructObject(node);
            if (clazz.isPrimitive()) {
                if (object2 == null) {
                    throw new NullPointerException("Unable to construct element value for " + node);
                }
                if (Byte.TYPE.equals(clazz)) {
                    Array.setByte(object, n2, ((Number)object2).byteValue());
                } else if (Short.TYPE.equals(clazz)) {
                    Array.setShort(object, n2, ((Number)object2).shortValue());
                } else if (Integer.TYPE.equals(clazz)) {
                    Array.setInt(object, n2, ((Number)object2).intValue());
                } else if (Long.TYPE.equals(clazz)) {
                    Array.setLong(object, n2, ((Number)object2).longValue());
                } else if (Float.TYPE.equals(clazz)) {
                    Array.setFloat(object, n2, ((Number)object2).floatValue());
                } else if (Double.TYPE.equals(clazz)) {
                    Array.setDouble(object, n2, ((Number)object2).doubleValue());
                } else if (Character.TYPE.equals(clazz)) {
                    Array.setChar(object, n2, ((Character)object2).charValue());
                } else {
                    if (!Boolean.TYPE.equals(clazz)) throw new YAMLException("unexpected primitive type");
                    Array.setBoolean(object, n2, (Boolean)object2);
                }
            } else {
                Array.set(object, n2, object2);
            }
            ++n2;
        }
        return object;
    }

    protected Set<Object> constructSet(MappingNode mappingNode) {
        Set<Object> set = this.newSet(mappingNode);
        this.constructSet2ndStep(mappingNode, set);
        return set;
    }

    protected Map<Object, Object> constructMapping(MappingNode mappingNode) {
        Map<Object, Object> map = this.newMap(mappingNode);
        this.constructMapping2ndStep(mappingNode, map);
        return map;
    }

    protected void constructMapping2ndStep(MappingNode mappingNode, Map<Object, Object> map) {
        Object object = ((CollectionNode)mappingNode).getValue();
        object = object.iterator();
        while (object.hasNext()) {
            NodeTuple nodeTuple = (NodeTuple)object.next();
            Node node = nodeTuple.getKeyNode();
            Object object2 = nodeTuple.getValueNode();
            Object object3 = this.constructObject(node);
            if (object3 != null) {
                try {
                    object3.hashCode();
                }
                catch (Exception exception) {
                    throw new ConstructorException("while constructing a mapping", mappingNode.getStartMark(), "found unacceptable key " + object3, nodeTuple.getKeyNode().getStartMark(), exception);
                }
            }
            object2 = this.constructObject((Node)object2);
            if (node.isTwoStepsConstruction()) {
                if (this.loadingConfig.getAllowRecursiveKeys()) {
                    this.postponeMapFilling(map, object3, object2);
                    continue;
                }
                throw new YAMLException("Recursive key for mapping is detected but it is not configured to be allowed.");
            }
            map.put(object3, object2);
        }
    }

    protected void postponeMapFilling(Map<Object, Object> map, Object object, Object object2) {
        this.maps2fill.add(0, new BaseConstructor$RecursiveTuple<Map<Object, Object>, BaseConstructor$RecursiveTuple<Object, Object>>(map, new BaseConstructor$RecursiveTuple<Object, Object>(object, object2)));
    }

    protected void constructSet2ndStep(MappingNode mappingNode, Set<Object> set) {
        Object object = ((CollectionNode)mappingNode).getValue();
        object = object.iterator();
        while (object.hasNext()) {
            NodeTuple nodeTuple = (NodeTuple)object.next();
            Node node = nodeTuple.getKeyNode();
            Object object2 = this.constructObject(node);
            if (object2 != null) {
                try {
                    object2.hashCode();
                }
                catch (Exception exception) {
                    throw new ConstructorException("while constructing a Set", mappingNode.getStartMark(), "found unacceptable key " + object2, nodeTuple.getKeyNode().getStartMark(), exception);
                }
            }
            if (node.isTwoStepsConstruction()) {
                this.postponeSetFilling(set, object2);
                continue;
            }
            set.add(object2);
        }
    }

    protected void postponeSetFilling(Set<Object> set, Object object) {
        this.sets2fill.add(0, new BaseConstructor$RecursiveTuple<Set<Object>, Object>(set, object));
    }

    public void setPropertyUtils(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
        this.explicitPropertyUtils = true;
        Object object = this.typeDefinitions.values();
        object = object.iterator();
        while (object.hasNext()) {
            TypeDescription typeDescription = (TypeDescription)object.next();
            typeDescription.setPropertyUtils(propertyUtils);
        }
    }

    public final PropertyUtils getPropertyUtils() {
        if (this.propertyUtils == null) {
            this.propertyUtils = new PropertyUtils();
        }
        return this.propertyUtils;
    }

    public TypeDescription addTypeDescription(TypeDescription typeDescription) {
        if (typeDescription == null) {
            throw new NullPointerException("TypeDescription is required.");
        }
        Tag tag = typeDescription.getTag();
        this.typeTags.put(tag, typeDescription.getType());
        typeDescription.setPropertyUtils(this.getPropertyUtils());
        return this.typeDefinitions.put(typeDescription.getType(), typeDescription);
    }

    public final boolean isExplicitPropertyUtils() {
        return this.explicitPropertyUtils;
    }

    public boolean isAllowDuplicateKeys() {
        return this.allowDuplicateKeys;
    }

    public void setAllowDuplicateKeys(boolean bl) {
        this.allowDuplicateKeys = bl;
    }

    public boolean isWrappedToRootException() {
        return this.wrappedToRootException;
    }

    public void setWrappedToRootException(boolean bl) {
        this.wrappedToRootException = bl;
    }

    public boolean isEnumCaseSensitive() {
        return this.enumCaseSensitive;
    }

    public void setEnumCaseSensitive(boolean bl) {
        this.enumCaseSensitive = bl;
    }
}

