/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.util.Collection;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Constructor$ConstructMapping;
import org.yaml.snakeyaml.constructor.Constructor$ConstructScalar;
import org.yaml.snakeyaml.constructor.Constructor$ConstructSequence;
import org.yaml.snakeyaml.constructor.Constructor$ConstructYamlObject;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;

public class Constructor
extends SafeConstructor {
    public Constructor() {
        this(Object.class);
    }

    public Constructor(LoaderOptions loaderOptions) {
        this(Object.class, loaderOptions);
    }

    public Constructor(Class<? extends Object> clazz) {
        this(new TypeDescription(Constructor.checkRoot(clazz)));
    }

    public Constructor(Class<? extends Object> clazz, LoaderOptions loaderOptions) {
        this(new TypeDescription(Constructor.checkRoot(clazz)), loaderOptions);
    }

    private static Class<? extends Object> checkRoot(Class<? extends Object> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Root class must be provided.");
        }
        return clazz;
    }

    public Constructor(TypeDescription typeDescription) {
        this(typeDescription, null, new LoaderOptions());
    }

    public Constructor(TypeDescription typeDescription, LoaderOptions loaderOptions) {
        this(typeDescription, null, loaderOptions);
    }

    public Constructor(TypeDescription typeDescription, Collection<TypeDescription> collection) {
        this(typeDescription, collection, new LoaderOptions());
    }

    public Constructor(TypeDescription object, Collection<TypeDescription> object2, LoaderOptions loaderOptions) {
        super(loaderOptions);
        if (object == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new Constructor$ConstructYamlObject(this));
        if (!Object.class.equals(((TypeDescription)object).getType())) {
            this.rootTag = new Tag(((TypeDescription)object).getType());
        }
        this.yamlClassConstructors.put(NodeId.scalar, new Constructor$ConstructScalar(this));
        this.yamlClassConstructors.put(NodeId.mapping, new Constructor$ConstructMapping(this));
        this.yamlClassConstructors.put(NodeId.sequence, new Constructor$ConstructSequence(this));
        this.addTypeDescription((TypeDescription)object);
        if (object2 != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (TypeDescription)object.next();
                this.addTypeDescription((TypeDescription)object2);
            }
        }
    }

    public Constructor(String string) {
        this(Class.forName(Constructor.check(string)));
    }

    public Constructor(String string, LoaderOptions loaderOptions) {
        this(Class.forName(Constructor.check(string)), loaderOptions);
    }

    private static final String check(String string) {
        if (string == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        if (string.trim().length() == 0) {
            throw new YAMLException("Root type must be provided.");
        }
        return string;
    }

    protected Class<?> getClassForNode(Node node) {
        Class<? extends Object> clazz = this.typeTags.get(node.getTag());
        if (clazz == null) {
            Class<?> clazz2;
            clazz = node.getTag().getClassName();
            try {
                clazz2 = this.getClassForName((String)((Object)clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new YAMLException("Class not found: " + (String)((Object)clazz));
            }
            this.typeTags.put(node.getTag(), clazz2);
            return clazz2;
        }
        return clazz;
    }

    public Class<?> getClassForName(String string) {
        try {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(string);
        }
    }
}

