/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.DuplicateKeyException;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructUndefined;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlBinary;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlBool;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlFloat;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlInt;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlMap;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlNull;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlOmap;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlPairs;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlSeq;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlSet;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlStr;
import org.yaml.snakeyaml.constructor.SafeConstructor$ConstructYamlTimestamp;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class SafeConstructor
extends BaseConstructor {
    public static final SafeConstructor$ConstructUndefined undefinedConstructor = new SafeConstructor$ConstructUndefined();
    private static final Map<String, Boolean> BOOL_VALUES = new HashMap<String, Boolean>();
    private static final int[][] RADIX_MAX;
    private static final Pattern TIMESTAMP_REGEXP;
    private static final Pattern YMD_REGEXP;

    public SafeConstructor() {
        this(new LoaderOptions());
    }

    public SafeConstructor(LoaderOptions loaderOptions) {
        super(loaderOptions);
        this.yamlConstructors.put(Tag.NULL, new SafeConstructor$ConstructYamlNull(this));
        this.yamlConstructors.put(Tag.BOOL, new SafeConstructor$ConstructYamlBool(this));
        this.yamlConstructors.put(Tag.INT, new SafeConstructor$ConstructYamlInt(this));
        this.yamlConstructors.put(Tag.FLOAT, new SafeConstructor$ConstructYamlFloat(this));
        this.yamlConstructors.put(Tag.BINARY, new SafeConstructor$ConstructYamlBinary(this));
        this.yamlConstructors.put(Tag.TIMESTAMP, new SafeConstructor$ConstructYamlTimestamp());
        this.yamlConstructors.put(Tag.OMAP, new SafeConstructor$ConstructYamlOmap(this));
        this.yamlConstructors.put(Tag.PAIRS, new SafeConstructor$ConstructYamlPairs(this));
        this.yamlConstructors.put(Tag.SET, new SafeConstructor$ConstructYamlSet(this));
        this.yamlConstructors.put(Tag.STR, new SafeConstructor$ConstructYamlStr(this));
        this.yamlConstructors.put(Tag.SEQ, new SafeConstructor$ConstructYamlSeq(this));
        this.yamlConstructors.put(Tag.MAP, new SafeConstructor$ConstructYamlMap(this));
        this.yamlConstructors.put(null, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.scalar, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.sequence, undefinedConstructor);
        this.yamlClassConstructors.put(NodeId.mapping, undefinedConstructor);
    }

    protected void flattenMapping(MappingNode mappingNode) {
        this.flattenMapping(mappingNode, false);
    }

    protected void flattenMapping(MappingNode mappingNode, boolean bl) {
        this.processDuplicateKeys(mappingNode, bl);
        if (mappingNode.isMerged()) {
            mappingNode.setValue(this.mergeNode(mappingNode, true, new HashMap<Object, Integer>(), new ArrayList<NodeTuple>(), bl));
        }
    }

    protected void processDuplicateKeys(MappingNode mappingNode) {
        this.processDuplicateKeys(mappingNode, false);
    }

    protected void processDuplicateKeys(MappingNode mappingNode, boolean bl) {
        List list = ((CollectionNode)mappingNode).getValue();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(list.size());
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n2 = 0;
        for (NodeTuple nodeTuple : list) {
            Object object = nodeTuple.getKeyNode();
            if (!((Node)object).getTag().equals(Tag.MERGE)) {
                Integer n3;
                if (bl) {
                    if (object instanceof ScalarNode) {
                        ((Node)object).setType(String.class);
                        ((Node)object).setTag(Tag.STR);
                    } else {
                        throw new YAMLException("Keys must be scalars but found: " + object);
                    }
                }
                if ((object = this.constructObject((Node)object)) != null && !bl) {
                    try {
                        object.hashCode();
                    }
                    catch (Exception exception) {
                        throw new ConstructorException("while constructing a mapping", mappingNode.getStartMark(), "found unacceptable key " + object, nodeTuple.getKeyNode().getStartMark(), exception);
                    }
                }
                if ((n3 = hashMap.put(object, n2)) != null) {
                    if (!this.isAllowDuplicateKeys()) {
                        throw new DuplicateKeyException(mappingNode.getStartMark(), object, nodeTuple.getKeyNode().getStartMark());
                    }
                    treeSet.add(n3);
                }
            }
            ++n2;
        }
        Iterator<Object> iterator = treeSet.descendingIterator();
        while (iterator.hasNext()) {
            list.remove((Integer)iterator.next());
        }
    }

    private List<NodeTuple> mergeNode(MappingNode mappingNode, boolean bl, Map<Object, Integer> map, List<NodeTuple> list, boolean bl2) {
        Iterator iterator = ((CollectionNode)mappingNode).getValue().iterator();
        block4: while (iterator.hasNext()) {
            Object object = (NodeTuple)iterator.next();
            Object object2 = ((NodeTuple)object).getKeyNode();
            Node node = ((NodeTuple)object).getValueNode();
            if (((Node)object2).getTag().equals(Tag.MERGE)) {
                iterator.remove();
                switch (node.getNodeId()) {
                    case mapping: {
                        object2 = (MappingNode)node;
                        this.mergeNode((MappingNode)object2, false, map, list, bl2);
                        continue block4;
                    }
                    case sequence: {
                        object = (SequenceNode)node;
                        object = ((CollectionNode)object).getValue();
                        object = object.iterator();
                        while (object.hasNext()) {
                            object2 = (Node)object.next();
                            if (!(object2 instanceof MappingNode)) {
                                throw new ConstructorException("while constructing a mapping", mappingNode.getStartMark(), "expected a mapping for merging, but found " + (Object)((Object)((Node)object2).getNodeId()), ((Node)object2).getStartMark());
                            }
                            object2 = (MappingNode)object2;
                            this.mergeNode((MappingNode)object2, false, map, list, bl2);
                        }
                        continue block4;
                    }
                }
                throw new ConstructorException("while constructing a mapping", mappingNode.getStartMark(), "expected a mapping or list of mappings for merging, but found " + (Object)((Object)node.getNodeId()), node.getStartMark());
            }
            if (bl2) {
                if (object2 instanceof ScalarNode) {
                    ((Node)object2).setType(String.class);
                    ((Node)object2).setTag(Tag.STR);
                } else {
                    throw new YAMLException("Keys must be scalars but found: " + object2);
                }
            }
            if (!map.containsKey(object2 = this.constructObject((Node)object2))) {
                list.add((NodeTuple)object);
                map.put(object2, list.size() - 1);
                continue;
            }
            if (!bl) continue;
            list.set(map.get(object2), (NodeTuple)object);
        }
        return list;
    }

    @Override
    protected void constructMapping2ndStep(MappingNode mappingNode, Map<Object, Object> map) {
        this.flattenMapping(mappingNode);
        super.constructMapping2ndStep(mappingNode, map);
    }

    @Override
    protected void constructSet2ndStep(MappingNode mappingNode, Set<Object> set) {
        this.flattenMapping(mappingNode);
        super.constructSet2ndStep(mappingNode, set);
    }

    private static int maxLen(int n2, int n3) {
        return Integer.toString(n2, n3).length();
    }

    private static int maxLen(long l2, int n2) {
        return Long.toString(l2, n2).length();
    }

    private Number createNumber(int n2, String string, int n3) {
        Number number;
        boolean bl;
        int[] nArray;
        int n4;
        int n5 = n4 = string != null ? string.length() : 0;
        if (n2 < 0) {
            string = "-" + string;
        }
        if ((nArray = n3 < RADIX_MAX.length ? RADIX_MAX[n3] : null) != null && (bl = n4 > nArray[0])) {
            if (n4 > nArray[1]) {
                return new BigInteger(string, n3);
            }
            return SafeConstructor.createLongOrBigInteger(string, n3);
        }
        try {
            number = Integer.valueOf(string, n3);
        }
        catch (NumberFormatException numberFormatException) {
            number = SafeConstructor.createLongOrBigInteger(string, n3);
        }
        return number;
    }

    protected static Number createLongOrBigInteger(String string, int n2) {
        try {
            return Long.valueOf(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigInteger(string, n2);
        }
    }

    static /* synthetic */ Map access$000() {
        return BOOL_VALUES;
    }

    static /* synthetic */ Number access$100(SafeConstructor safeConstructor, int n2, String string, int n3) {
        return safeConstructor.createNumber(n2, string, n3);
    }

    static /* synthetic */ Pattern access$200() {
        return YMD_REGEXP;
    }

    static /* synthetic */ Pattern access$300() {
        return TIMESTAMP_REGEXP;
    }

    static {
        BOOL_VALUES.put("yes", Boolean.TRUE);
        BOOL_VALUES.put("no", Boolean.FALSE);
        BOOL_VALUES.put("true", Boolean.TRUE);
        BOOL_VALUES.put("false", Boolean.FALSE);
        BOOL_VALUES.put("on", Boolean.TRUE);
        BOOL_VALUES.put("off", Boolean.FALSE);
        RADIX_MAX = new int[17][2];
        int[] nArray = new int[]{2, 8, 10, 16};
        int[] nArray2 = nArray;
        nArray2 = nArray;
        int cfr_ignored_0 = nArray.length;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = nArray2[i2];
            SafeConstructor.RADIX_MAX[n2] = new int[]{SafeConstructor.maxLen(Integer.MAX_VALUE, n2), SafeConstructor.maxLen(Long.MAX_VALUE, n2)};
        }
        TIMESTAMP_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");
        YMD_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");
    }
}

