/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.error;

import java.io.Serializable;
import org.yaml.snakeyaml.scanner.Constant;

public final class Mark
implements Serializable {
    private String name;
    private int index;
    private int line;
    private int column;
    private int[] buffer;
    private int pointer;

    private static int[] toCodePoints(char[] cArray) {
        int[] nArray = new int[Character.codePointCount(cArray, 0, cArray.length)];
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            int n4;
            nArray[n3] = n4 = Character.codePointAt(cArray, n2);
            n2 += Character.charCount(n4);
            ++n3;
        }
        return nArray;
    }

    public Mark(String string, int n2, int n3, int n4, char[] cArray, int n5) {
        this(string, n2, n3, n4, Mark.toCodePoints(cArray), n5);
    }

    @Deprecated
    public Mark(String string, int n2, int n3, int n4, String string2, int n5) {
        this(string, n2, n3, n4, string2.toCharArray(), n5);
    }

    public Mark(String string, int n2, int n3, int n4, int[] nArray, int n5) {
        this.name = string;
        this.index = n2;
        this.line = n3;
        this.column = n4;
        this.buffer = nArray;
        this.pointer = n5;
    }

    private boolean isLineBreak(int n2) {
        return Constant.NULL_OR_LINEBR.has(n2);
    }

    public final String get_snippet(int n2, int n3) {
        int n4;
        float f2 = (float)n3 / 2.0f - 1.0f;
        int n5 = this.pointer;
        String string = "";
        while (n5 > 0) {
            Mark mark = this;
            if (mark.isLineBreak(mark.buffer[n5 - 1])) break;
            if (!((float)(this.pointer - --n5) > f2)) continue;
            string = " ... ";
            n5 += 5;
            break;
        }
        String string2 = "";
        int n6 = this.pointer;
        while (n6 < this.buffer.length) {
            Mark mark = this;
            if (mark.isLineBreak(mark.buffer[n6])) break;
            if (!((float)(++n6 - this.pointer) > f2)) continue;
            string2 = " ... ";
            n6 -= 5;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n4 = 0; n4 < n2; ++n4) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string);
        for (n4 = n5; n4 < n6; ++n4) {
            stringBuilder.appendCodePoint(this.buffer[n4]);
        }
        stringBuilder.append(string2);
        stringBuilder.append("\n");
        for (n4 = 0; n4 < n2 + this.pointer - n5 + string.length(); ++n4) {
            stringBuilder.append(" ");
        }
        stringBuilder.append("^");
        return stringBuilder.toString();
    }

    public final String get_snippet() {
        return this.get_snippet(4, 75);
    }

    public final String toString() {
        String string = this.get_snippet();
        StringBuilder stringBuilder = new StringBuilder(" in ");
        stringBuilder.append(this.name);
        stringBuilder.append(", line ");
        stringBuilder.append(this.line + 1);
        stringBuilder.append(", column ");
        stringBuilder.append(this.column + 1);
        stringBuilder.append(":\n");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public final String getName() {
        return this.name;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int[] getBuffer() {
        return this.buffer;
    }

    public final int getPointer() {
        return this.pointer;
    }
}

