/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.extensions.compactnotation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.extensions.compactnotation.CompactConstructor$ConstructCompactObject;
import org.yaml.snakeyaml.extensions.compactnotation.CompactData;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class CompactConstructor
extends Constructor {
    private static final Pattern GUESS_COMPACT = Pattern.compile("\\p{Alpha}.*\\s*\\((?:,?\\s*(?:(?:\\w*)|(?:\\p{Alpha}\\w*\\s*=.+))\\s*)+\\)");
    private static final Pattern FIRST_PATTERN = Pattern.compile("(\\p{Alpha}.*)(\\s*)\\((.*?)\\)");
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("\\s*(\\p{Alpha}\\w*)\\s*=(.+)");
    private Construct compactConstruct;

    protected Object constructCompactFormat(ScalarNode object, CompactData object2) {
        try {
            object = this.createInstance((ScalarNode)object, (CompactData)object2);
            object2 = new HashMap<String, String>(((CompactData)object2).getProperties());
            this.setProperties(object, (Map<String, Object>)object2);
            return object;
        }
        catch (Exception exception) {
            throw new YAMLException(exception);
        }
    }

    protected Object createInstance(ScalarNode object, CompactData compactData) {
        object = this.getClassForName(compactData.getPrefix());
        Class[] classArray = new Class[compactData.getArguments().size()];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            classArray[i2] = String.class;
        }
        java.lang.reflect.Constructor constructor = ((Class)object).getDeclaredConstructor(classArray);
        constructor.setAccessible(true);
        return constructor.newInstance(compactData.getArguments().toArray());
    }

    protected void setProperties(Object object, Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("Data for Compact Object Notation cannot be null.");
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Property property = this.getPropertyUtils().getProperty(object.getClass(), string);
            try {
                property.set(object, entry.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new YAMLException("Cannot set property='" + string + "' with value='" + map.get(string) + "' (" + map.get(string).getClass() + ") in " + object);
            }
        }
    }

    public CompactData getCompactData(String stringArray) {
        if (!stringArray.endsWith(")")) {
            return null;
        }
        if (stringArray.indexOf(40) < 0) {
            return null;
        }
        if ((stringArray = FIRST_PATTERN.matcher((CharSequence)stringArray)).matches()) {
            Object object = stringArray.group(1).trim();
            stringArray = stringArray.group(3);
            object = new CompactData((String)object);
            if (stringArray.length() == 0) {
                return object;
            }
            stringArray = stringArray.split("\\s*,\\s*");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Object object2 = stringArray[i2];
                if (((String)object2).indexOf(61) < 0) {
                    ((CompactData)object).getArguments().add((String)object2);
                    continue;
                }
                if (((Matcher)(object2 = PROPERTY_NAME_PATTERN.matcher((CharSequence)object2))).matches()) {
                    String string = ((Matcher)object2).group(1);
                    object2 = ((Matcher)object2).group(2).trim();
                    ((CompactData)object).getProperties().put(string, (String)object2);
                    continue;
                }
                return null;
            }
            return object;
        }
        return null;
    }

    private Construct getCompactConstruct() {
        if (this.compactConstruct == null) {
            this.compactConstruct = this.createCompactConstruct();
        }
        return this.compactConstruct;
    }

    protected Construct createCompactConstruct() {
        return new CompactConstructor$ConstructCompactObject(this);
    }

    @Override
    public Construct getConstructor(Node node) {
        ScalarNode scalarNode;
        if (node instanceof MappingNode) {
            Object object = (MappingNode)node;
            if ((object = ((CollectionNode)object).getValue()).size() == 1) {
                object = (NodeTuple)object.get(0);
                if ((object = ((NodeTuple)object).getKeyNode()) instanceof ScalarNode && GUESS_COMPACT.matcher(((ScalarNode)(object = (ScalarNode)object)).getValue()).matches()) {
                    return this.getCompactConstruct();
                }
            }
        } else if (node instanceof ScalarNode && GUESS_COMPACT.matcher((scalarNode = (ScalarNode)node).getValue()).matches()) {
            return this.getCompactConstruct();
        }
        return super.getConstructor(node);
    }

    protected void applySequence(Object object, List<?> list) {
        try {
            Property property = this.getPropertyUtils().getProperty(object.getClass(), this.getSequencePropertyName(object.getClass()));
            property.set(object, list);
            return;
        }
        catch (Exception exception) {
            throw new YAMLException(exception);
        }
    }

    protected String getSequencePropertyName(Class<?> clazz) {
        Set<Property> set = this.getPropertyUtils().getProperties(clazz);
        Iterator<Property> iterator = set.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            if (List.class.isAssignableFrom(property.getType())) continue;
            iterator.remove();
        }
        if (set.size() == 0) {
            throw new YAMLException("No list property found in " + clazz);
        }
        if (set.size() > 1) {
            throw new YAMLException("Many list properties found in " + clazz + "; Please override getSequencePropertyName() to specify which property to use.");
        }
        return set.iterator().next().getName();
    }

    static /* synthetic */ List access$000(CompactConstructor compactConstructor, SequenceNode sequenceNode) {
        return compactConstructor.constructSequence(sequenceNode);
    }

    static /* synthetic */ String access$100(CompactConstructor compactConstructor, ScalarNode scalarNode) {
        return compactConstructor.constructScalar(scalarNode);
    }
}

