/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.external.com.google.gdata.util.common.base;

import org.yaml.snakeyaml.external.com.google.gdata.util.common.base.UnicodeEscaper;

public class PercentEscaper
extends UnicodeEscaper {
    public static final String SAFECHARS_URLENCODER = "-_.*";
    public static final String SAFEPATHCHARS_URLENCODER = "-_.!~*'()@:$&,;=";
    public static final String SAFEQUERYSTRINGCHARS_URLENCODER = "-_.!~*'()@:$,;/?:";
    private static final char[] URI_ESCAPED_SPACE = new char[]{'+'};
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private final boolean plusForSpace;
    private final boolean[] safeOctets;

    public PercentEscaper(String string, boolean bl) {
        if (string.matches(".*[0-9A-Za-z].*")) {
            throw new IllegalArgumentException("Alphanumeric characters are always 'safe' and should not be explicitly specified");
        }
        if (bl && string.contains(" ")) {
            throw new IllegalArgumentException("plusForSpace cannot be specified when space is a 'safe' character");
        }
        if (string.contains("%")) {
            throw new IllegalArgumentException("The '%' character cannot be specified as 'safe'");
        }
        this.plusForSpace = bl;
        this.safeOctets = PercentEscaper.createSafeOctets(string);
    }

    private static boolean[] createSafeOctets(String object) {
        int n2 = 122;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        Object[] objectArray = cArray;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = objectArray[i2];
            n2 = Math.max(n4, n2);
        }
        objectArray = new boolean[n2 + 1];
        for (n3 = 48; n3 <= 57; ++n3) {
            objectArray[n3] = '\u0001';
        }
        for (n3 = 65; n3 <= 90; ++n3) {
            objectArray[n3] = '\u0001';
        }
        for (n3 = 97; n3 <= 122; ++n3) {
            objectArray[n3] = '\u0001';
        }
        for (Object object2 : object) {
            objectArray[object2] = '\u0001';
        }
        return objectArray;
    }

    @Override
    protected int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        char c2;
        while (n2 < n3 && (c2 = charSequence.charAt(n2)) < this.safeOctets.length && this.safeOctets[c2]) {
            ++n2;
        }
        return n2;
    }

    @Override
    public String escape(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < this.safeOctets.length && this.safeOctets[c2]) continue;
            return this.escapeSlow(string, i2);
        }
        return string;
    }

    @Override
    protected char[] escape(int n2) {
        if (n2 < this.safeOctets.length && this.safeOctets[n2]) {
            return null;
        }
        if (n2 == 32 && this.plusForSpace) {
            return URI_ESCAPED_SPACE;
        }
        if (n2 <= 127) {
            char[] cArray = new char[3];
            char[] cArray2 = cArray;
            cArray[0] = 37;
            cArray2[2] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray2[1] = UPPER_HEX_DIGITS[n2 >>> 4];
            return cArray2;
        }
        if (n2 <= 2047) {
            char[] cArray = new char[6];
            char[] cArray3 = cArray;
            cArray[0] = 37;
            cArray3[3] = 37;
            cArray3[5] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray3[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray3[2] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray3[1] = UPPER_HEX_DIGITS[0xC | (n2 >>>= 4)];
            return cArray3;
        }
        if (n2 <= 65535) {
            char[] cArray = new char[9];
            char[] cArray4 = cArray;
            cArray[0] = 37;
            cArray4[1] = 69;
            cArray4[3] = 37;
            cArray4[6] = 37;
            cArray4[8] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray4[7] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray4[5] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray4[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray4[2] = UPPER_HEX_DIGITS[n2 >>>= 2];
            return cArray4;
        }
        if (n2 <= 0x10FFFF) {
            char[] cArray = new char[12];
            char[] cArray5 = cArray;
            cArray[0] = 37;
            cArray5[1] = 70;
            cArray5[3] = 37;
            cArray5[6] = 37;
            cArray5[9] = 37;
            cArray5[11] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray5[10] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray5[8] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray5[7] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray5[5] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray5[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray5[2] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 7];
            return cArray5;
        }
        throw new IllegalArgumentException("Invalid unicode character value " + n2);
    }
}

