/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.introspector;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils$1;
import org.yaml.snakeyaml.util.PlatformFeatureDetector;

public class PropertyUtils {
    private final Map<Class<?>, Map<String, Property>> propertiesCache = new HashMap();
    private final Map<Class<?>, Set<Property>> readableProperties = new HashMap();
    private BeanAccess beanAccess = BeanAccess.DEFAULT;
    private boolean allowReadOnlyProperties = false;
    private boolean skipMissingProperties = false;
    private PlatformFeatureDetector platformFeatureDetector;
    private static final String TRANSIENT = "transient";

    public PropertyUtils() {
        this(new PlatformFeatureDetector());
    }

    PropertyUtils(PlatformFeatureDetector platformFeatureDetector) {
        this.platformFeatureDetector = platformFeatureDetector;
        if (platformFeatureDetector.isRunningOnAndroid()) {
            this.beanAccess = BeanAccess.FIELD;
        }
    }

    protected Map<String, Property> getPropertiesMap(Class<?> clazz, BeanAccess object) {
        if (this.propertiesCache.containsKey(clazz)) {
            return this.propertiesCache.get(clazz);
        }
        LinkedHashMap<String, Property> linkedHashMap = new LinkedHashMap<String, Property>();
        boolean bl = false;
        switch (PropertyUtils$1.$SwitchMap$org$yaml$snakeyaml$introspector$BeanAccess[((Enum)object).ordinal()]) {
            case 1: {
                for (object = clazz; object != null; object = ((Class)object).getSuperclass()) {
                    for (Field field : ((Class)object).getDeclaredFields()) {
                        int n2 = field.getModifiers();
                        if (Modifier.isStatic(n2) || Modifier.isTransient(n2) || linkedHashMap.containsKey(field.getName())) continue;
                        linkedHashMap.put(field.getName(), new FieldProperty(field));
                    }
                }
                break;
            }
            default: {
                try {
                    object = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                    int n3 = ((PropertyDescriptor[])object).length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Object object2 = object[i2];
                        Method accessibleObject = ((PropertyDescriptor)object2).getReadMethod();
                        if (accessibleObject != null && accessibleObject.getName().equals("getClass") || this.isTransient((FeatureDescriptor)object2)) continue;
                        linkedHashMap.put(((FeatureDescriptor)object2).getName(), new MethodProperty((PropertyDescriptor)object2));
                    }
                }
                catch (IntrospectionException introspectionException) {
                    throw new YAMLException(introspectionException);
                }
                for (object = clazz; object != null; object = ((Class)object).getSuperclass()) {
                    for (Field field : ((Class)object).getDeclaredFields()) {
                        int n3 = field.getModifiers();
                        if (Modifier.isStatic(n3) || Modifier.isTransient(n3)) continue;
                        if (Modifier.isPublic(n3)) {
                            linkedHashMap.put(field.getName(), new FieldProperty(field));
                            continue;
                        }
                        bl = true;
                    }
                }
            }
        }
        if (linkedHashMap.isEmpty() && bl) {
            throw new YAMLException("No JavaBean properties found in " + clazz.getName());
        }
        this.propertiesCache.put(clazz, linkedHashMap);
        return linkedHashMap;
    }

    private boolean isTransient(FeatureDescriptor featureDescriptor) {
        return Boolean.TRUE.equals(featureDescriptor.getValue(TRANSIENT));
    }

    public Set<Property> getProperties(Class<? extends Object> clazz) {
        return this.getProperties(clazz, this.beanAccess);
    }

    public Set<Property> getProperties(Class<? extends Object> clazz, BeanAccess object) {
        if (this.readableProperties.containsKey(clazz)) {
            return this.readableProperties.get(clazz);
        }
        object = this.createPropertySet(clazz, (BeanAccess)((Object)object));
        this.readableProperties.put(clazz, (Set<Property>)object);
        return object;
    }

    protected Set<Property> createPropertySet(Class<? extends Object> iterator, BeanAccess object) {
        TreeSet<Property> treeSet = new TreeSet<Property>();
        iterator = this.getPropertiesMap((Class<?>)((Object)iterator), (BeanAccess)((Object)object)).values();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((Property)object).isReadable() || !this.allowReadOnlyProperties && !((Property)object).isWritable()) continue;
            treeSet.add((Property)object);
        }
        return treeSet;
    }

    public Property getProperty(Class<? extends Object> clazz, String string) {
        return this.getProperty(clazz, string, this.beanAccess);
    }

    public Property getProperty(Class<? extends Object> clazz, String string, BeanAccess object) {
        object = this.getPropertiesMap(clazz, (BeanAccess)((Object)object));
        if ((object = object.get(string)) == null && this.skipMissingProperties) {
            object = new MissingProperty(string);
        }
        if (object == null) {
            throw new YAMLException("Unable to find property '" + string + "' on class: " + clazz.getName());
        }
        return object;
    }

    public void setBeanAccess(BeanAccess beanAccess) {
        if (this.platformFeatureDetector.isRunningOnAndroid() && beanAccess != BeanAccess.FIELD) {
            throw new IllegalArgumentException("JVM is Android - only BeanAccess.FIELD is available");
        }
        if (this.beanAccess != beanAccess) {
            this.beanAccess = beanAccess;
            this.propertiesCache.clear();
            this.readableProperties.clear();
        }
    }

    public void setAllowReadOnlyProperties(boolean bl) {
        if (this.allowReadOnlyProperties != bl) {
            this.allowReadOnlyProperties = bl;
            this.readableProperties.clear();
        }
    }

    public boolean isAllowReadOnlyProperties() {
        return this.allowReadOnlyProperties;
    }

    public void setSkipMissingProperties(boolean bl) {
        if (this.skipMissingProperties != bl) {
            this.skipMissingProperties = bl;
            this.readableProperties.clear();
        }
    }

    public boolean isSkipMissingProperties() {
        return this.skipMissingProperties;
    }
}

