/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.nodes;

import java.util.List;
import org.yaml.snakeyaml.DumperOptions$FlowStyle;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;

public class MappingNode
extends CollectionNode<NodeTuple> {
    private List<NodeTuple> value;
    private boolean merged = false;

    public MappingNode(Tag tag, boolean bl, List<NodeTuple> list, Mark mark, Mark mark2, DumperOptions$FlowStyle dumperOptions$FlowStyle) {
        super(tag, mark, mark2, dumperOptions$FlowStyle);
        if (list == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = list;
        this.resolved = bl;
    }

    public MappingNode(Tag tag, List<NodeTuple> list, DumperOptions$FlowStyle dumperOptions$FlowStyle) {
        this(tag, true, list, null, null, dumperOptions$FlowStyle);
    }

    @Deprecated
    public MappingNode(Tag tag, boolean bl, List<NodeTuple> list, Mark mark, Mark mark2, Boolean bl2) {
        this(tag, bl, list, mark, mark2, DumperOptions$FlowStyle.fromBoolean(bl2));
    }

    @Deprecated
    public MappingNode(Tag tag, List<NodeTuple> list, Boolean bl) {
        this(tag, list, DumperOptions$FlowStyle.fromBoolean(bl));
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.mapping;
    }

    @Override
    public List<NodeTuple> getValue() {
        return this.value;
    }

    public void setValue(List<NodeTuple> list) {
        this.value = list;
    }

    public void setOnlyKeyType(Class<? extends Object> clazz) {
        for (NodeTuple nodeTuple : this.value) {
            nodeTuple.getKeyNode().setType(clazz);
        }
    }

    public void setTypes(Class<? extends Object> clazz, Class<? extends Object> clazz2) {
        for (NodeTuple nodeTuple : this.value) {
            nodeTuple.getValueNode().setType(clazz2);
            nodeTuple.getKeyNode().setType(clazz);
        }
    }

    public String toString() {
        CharSequence charSequence = new StringBuilder();
        for (NodeTuple nodeTuple : ((CollectionNode)this).getValue()) {
            ((StringBuilder)charSequence).append("{ key=");
            ((StringBuilder)charSequence).append(nodeTuple.getKeyNode());
            ((StringBuilder)charSequence).append("; value=");
            if (nodeTuple.getValueNode() instanceof CollectionNode) {
                ((StringBuilder)charSequence).append(System.identityHashCode(nodeTuple.getValueNode()));
            } else {
                ((StringBuilder)charSequence).append(nodeTuple.toString());
            }
            ((StringBuilder)charSequence).append(" }");
        }
        charSequence = ((StringBuilder)charSequence).toString();
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", values=" + (String)charSequence + ")>";
    }

    public void setMerged(boolean bl) {
        this.merged = bl;
    }

    public boolean isMerged() {
        return this.merged;
    }
}

