/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.nodes;

import org.yaml.snakeyaml.DumperOptions$ScalarStyle;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;

public class ScalarNode
extends Node {
    private DumperOptions$ScalarStyle style;
    private String value;

    public ScalarNode(Tag tag, String string, Mark mark, Mark mark2, DumperOptions$ScalarStyle dumperOptions$ScalarStyle) {
        this(tag, true, string, mark, mark2, dumperOptions$ScalarStyle);
    }

    public ScalarNode(Tag tag, boolean bl, String string, Mark mark, Mark mark2, DumperOptions$ScalarStyle dumperOptions$ScalarStyle) {
        super(tag, mark, mark2);
        if (string == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = string;
        if (dumperOptions$ScalarStyle == null) {
            throw new NullPointerException("Scalar style must be provided.");
        }
        this.style = dumperOptions$ScalarStyle;
        this.resolved = bl;
    }

    @Deprecated
    public ScalarNode(Tag tag, String string, Mark mark, Mark mark2, Character c2) {
        this(tag, string, mark, mark2, DumperOptions$ScalarStyle.createStyle(c2));
    }

    @Deprecated
    public ScalarNode(Tag tag, boolean bl, String string, Mark mark, Mark mark2, Character c2) {
        this(tag, bl, string, mark, mark2, DumperOptions$ScalarStyle.createStyle(c2));
    }

    @Deprecated
    public Character getStyle() {
        return this.style.getChar();
    }

    public DumperOptions$ScalarStyle getScalarStyle() {
        return this.style;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.scalar;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", value=" + this.getValue() + ")>";
    }

    public boolean isPlain() {
        return this.style == DumperOptions$ScalarStyle.PLAIN;
    }
}

