/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions$FlowStyle;
import org.yaml.snakeyaml.DumperOptions$ScalarStyle;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.BaseRepresenter$1;
import org.yaml.snakeyaml.representer.Represent;

public abstract class BaseRepresenter {
    protected final Map<Class<?>, Represent> representers = new HashMap();
    protected Represent nullRepresenter;
    protected final Map<Class<?>, Represent> multiRepresenters = new LinkedHashMap();
    protected DumperOptions$ScalarStyle defaultScalarStyle = null;
    protected DumperOptions$FlowStyle defaultFlowStyle = DumperOptions$FlowStyle.AUTO;
    protected final Map<Object, Node> representedObjects = new BaseRepresenter$1(this);
    protected Object objectToRepresent;
    private PropertyUtils propertyUtils;
    private boolean explicitPropertyUtils = false;

    public Node represent(Object object) {
        object = this.representData(object);
        this.representedObjects.clear();
        this.objectToRepresent = null;
        return object;
    }

    protected final Node representData(Object object) {
        this.objectToRepresent = object;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            object = this.representedObjects.get(this.objectToRepresent);
            return object;
        }
        if (object == null) {
            object = this.nullRepresenter.representData(null);
            return object;
        }
        Class<?> clazz = object.getClass();
        if (this.representers.containsKey(clazz)) {
            clazz = this.representers.get(clazz);
            object = clazz.representData(object);
        } else {
            clazz = this.multiRepresenters.keySet().iterator();
            while (clazz.hasNext()) {
                Class clazz2 = (Class)clazz.next();
                if (clazz2 == null || !clazz2.isInstance(object)) continue;
                clazz = this.multiRepresenters.get(clazz2);
                object = clazz.representData(object);
                return object;
            }
            if (this.multiRepresenters.containsKey(null)) {
                clazz = this.multiRepresenters.get(null);
                object = clazz.representData(object);
            } else {
                clazz = this.representers.get(null);
                object = clazz.representData(object);
            }
        }
        return object;
    }

    protected Node representScalar(Tag object, String string, DumperOptions$ScalarStyle dumperOptions$ScalarStyle) {
        if (dumperOptions$ScalarStyle == null) {
            dumperOptions$ScalarStyle = this.defaultScalarStyle;
        }
        object = new ScalarNode((Tag)object, string, null, null, dumperOptions$ScalarStyle);
        return object;
    }

    protected Node representScalar(Tag tag, String string) {
        return this.representScalar(tag, string, null);
    }

    protected Node representSequence(Tag object, Iterable<?> object2, DumperOptions$FlowStyle dumperOptions$FlowStyle) {
        int n2 = 10;
        if (object2 instanceof List) {
            n2 = ((List)object2).size();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(n2);
        object = new SequenceNode((Tag)object, arrayList, dumperOptions$FlowStyle);
        this.representedObjects.put(this.objectToRepresent, (Node)object);
        DumperOptions$FlowStyle dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.FLOW;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            if (!((object3 = this.representData(object3)) instanceof ScalarNode) || !((ScalarNode)object3).isPlain()) {
                dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.BLOCK;
            }
            arrayList.add((Node)object3);
        }
        if (dumperOptions$FlowStyle == DumperOptions$FlowStyle.AUTO) {
            if (this.defaultFlowStyle != DumperOptions$FlowStyle.AUTO) {
                ((CollectionNode)object).setFlowStyle(this.defaultFlowStyle);
            } else {
                ((CollectionNode)object).setFlowStyle(dumperOptions$FlowStyle2);
            }
        }
        return object;
    }

    protected Node representMapping(Tag object, Map<?, ?> object2, DumperOptions$FlowStyle dumperOptions$FlowStyle) {
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>(object2.size());
        object = new MappingNode((Tag)object, arrayList, dumperOptions$FlowStyle);
        this.representedObjects.put(this.objectToRepresent, (Node)object);
        DumperOptions$FlowStyle dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.FLOW;
        for (Map.Entry entry : object2.entrySet()) {
            Node node = this.representData(entry.getKey());
            Node object3 = this.representData(entry.getValue());
            if (!(node instanceof ScalarNode) || !((ScalarNode)node).isPlain()) {
                dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.BLOCK;
            }
            if (!(object3 instanceof ScalarNode) || !((ScalarNode)object3).isPlain()) {
                dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.BLOCK;
            }
            arrayList.add(new NodeTuple(node, object3));
        }
        if (dumperOptions$FlowStyle == DumperOptions$FlowStyle.AUTO) {
            if (this.defaultFlowStyle != DumperOptions$FlowStyle.AUTO) {
                ((CollectionNode)object).setFlowStyle(this.defaultFlowStyle);
            } else {
                ((CollectionNode)object).setFlowStyle(dumperOptions$FlowStyle2);
            }
        }
        return object;
    }

    public void setDefaultScalarStyle(DumperOptions$ScalarStyle dumperOptions$ScalarStyle) {
        this.defaultScalarStyle = dumperOptions$ScalarStyle;
    }

    public DumperOptions$ScalarStyle getDefaultScalarStyle() {
        if (this.defaultScalarStyle == null) {
            return DumperOptions$ScalarStyle.PLAIN;
        }
        return this.defaultScalarStyle;
    }

    public void setDefaultFlowStyle(DumperOptions$FlowStyle dumperOptions$FlowStyle) {
        this.defaultFlowStyle = dumperOptions$FlowStyle;
    }

    public DumperOptions$FlowStyle getDefaultFlowStyle() {
        return this.defaultFlowStyle;
    }

    public void setPropertyUtils(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
        this.explicitPropertyUtils = true;
    }

    public final PropertyUtils getPropertyUtils() {
        if (this.propertyUtils == null) {
            this.propertyUtils = new PropertyUtils();
        }
        return this.propertyUtils;
    }

    public final boolean isExplicitPropertyUtils() {
        return this.explicitPropertyUtils;
    }
}

