/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.DumperOptions$NonPrintableStyle;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.BaseRepresenter;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentArray;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentBoolean;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentByteArray;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentDate;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentEnum;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentIterator;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentList;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentMap;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentNull;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentNumber;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentPrimitiveArray;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentSet;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentString;
import org.yaml.snakeyaml.representer.SafeRepresenter$RepresentUuid;

class SafeRepresenter
extends BaseRepresenter {
    protected Map<Class<? extends Object>, Tag> classTags;
    protected TimeZone timeZone = null;
    protected DumperOptions$NonPrintableStyle nonPrintableStyle;
    private static final Pattern MULTILINE_PATTERN = Pattern.compile("\n|\u0085|\u2028|\u2029");

    public SafeRepresenter() {
        this(new DumperOptions());
    }

    public SafeRepresenter(DumperOptions dumperOptions) {
        this.nullRepresenter = new SafeRepresenter$RepresentNull(this);
        this.representers.put(String.class, new SafeRepresenter$RepresentString(this));
        this.representers.put(Boolean.class, new SafeRepresenter$RepresentBoolean(this));
        this.representers.put(Character.class, new SafeRepresenter$RepresentString(this));
        this.representers.put(UUID.class, new SafeRepresenter$RepresentUuid(this));
        this.representers.put(byte[].class, new SafeRepresenter$RepresentByteArray(this));
        SafeRepresenter$RepresentPrimitiveArray safeRepresenter$RepresentPrimitiveArray = new SafeRepresenter$RepresentPrimitiveArray(this);
        this.representers.put(short[].class, safeRepresenter$RepresentPrimitiveArray);
        this.representers.put(int[].class, safeRepresenter$RepresentPrimitiveArray);
        this.representers.put(long[].class, safeRepresenter$RepresentPrimitiveArray);
        this.representers.put(float[].class, safeRepresenter$RepresentPrimitiveArray);
        this.representers.put(double[].class, safeRepresenter$RepresentPrimitiveArray);
        this.representers.put(char[].class, safeRepresenter$RepresentPrimitiveArray);
        this.representers.put(boolean[].class, safeRepresenter$RepresentPrimitiveArray);
        this.multiRepresenters.put(Number.class, new SafeRepresenter$RepresentNumber(this));
        this.multiRepresenters.put(List.class, new SafeRepresenter$RepresentList(this));
        this.multiRepresenters.put(Map.class, new SafeRepresenter$RepresentMap(this));
        this.multiRepresenters.put(Set.class, new SafeRepresenter$RepresentSet(this));
        this.multiRepresenters.put(Iterator.class, new SafeRepresenter$RepresentIterator(this));
        this.multiRepresenters.put(new Object[0].getClass(), new SafeRepresenter$RepresentArray(this));
        this.multiRepresenters.put(Date.class, new SafeRepresenter$RepresentDate(this));
        this.multiRepresenters.put(Enum.class, new SafeRepresenter$RepresentEnum(this));
        this.multiRepresenters.put(Calendar.class, new SafeRepresenter$RepresentDate(this));
        this.classTags = new HashMap<Class<? extends Object>, Tag>();
        this.nonPrintableStyle = dumperOptions.getNonPrintableStyle();
    }

    protected Tag getTag(Class<?> clazz, Tag tag) {
        if (this.classTags.containsKey(clazz)) {
            return this.classTags.get(clazz);
        }
        return tag;
    }

    public Tag addClassTag(Class<? extends Object> clazz, Tag tag) {
        if (tag == null) {
            throw new NullPointerException("Tag must be provided.");
        }
        return this.classTags.put(clazz, tag);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    static /* synthetic */ Pattern access$000() {
        return MULTILINE_PATTERN;
    }
}

