/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.scanner;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions$ScalarStyle;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Constant;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerException;
import org.yaml.snakeyaml.scanner.ScannerImpl$Chomping;
import org.yaml.snakeyaml.scanner.SimpleKey;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.yaml.snakeyaml.tokens.CommentToken;
import org.yaml.snakeyaml.tokens.DirectiveToken;
import org.yaml.snakeyaml.tokens.DocumentEndToken;
import org.yaml.snakeyaml.tokens.DocumentStartToken;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.TagTuple;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.Token$ID;
import org.yaml.snakeyaml.tokens.ValueToken;
import org.yaml.snakeyaml.util.ArrayStack;
import org.yaml.snakeyaml.util.UriEncoder;

public final class ScannerImpl
implements Scanner {
    private static final Pattern NOT_HEXA = Pattern.compile("[^0-9A-Fa-f]");
    public static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    public static final Map<Character, Integer> ESCAPE_CODES = new HashMap<Character, Integer>();
    private final StreamReader reader;
    private boolean done = false;
    private int flowLevel = 0;
    private List<Token> tokens;
    private Token lastToken;
    private int tokensTaken = 0;
    private int indent = -1;
    private ArrayStack<Integer> indents;
    private boolean parseComments = false;
    private boolean allowSimpleKey = true;
    private Map<Integer, SimpleKey> possibleSimpleKeys;

    public ScannerImpl(StreamReader streamReader) {
        this.reader = streamReader;
        this.tokens = new ArrayList<Token>(100);
        this.indents = new ArrayStack(10);
        this.possibleSimpleKeys = new LinkedHashMap<Integer, SimpleKey>();
        this.fetchStreamStart();
    }

    public final ScannerImpl setParseComments(boolean bl) {
        this.parseComments = bl;
        return this;
    }

    public final boolean isParseComments() {
        return this.parseComments;
    }

    @Override
    public final boolean checkToken(Token$ID ... token$IDArray) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            if (token$IDArray.length == 0) {
                return true;
            }
            Token$ID token$ID = this.tokens.get(0).getTokenId();
            for (int i2 = 0; i2 < token$IDArray.length; ++i2) {
                if (token$ID != token$IDArray[i2]) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final Token peekToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.get(0);
    }

    @Override
    public final Token getToken() {
        ++this.tokensTaken;
        return this.tokens.remove(0);
    }

    private void addToken(Token token) {
        this.lastToken = token;
        this.tokens.add(token);
    }

    private void addToken(int n2, Token token) {
        if (n2 == this.tokens.size()) {
            this.lastToken = token;
        }
        this.tokens.add(n2, token);
    }

    private void addAllTokens(List<Token> list) {
        List<Token> list2 = list;
        this.lastToken = list2.get(list2.size() - 1);
        this.tokens.addAll(list);
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        return this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private void fetchMoreTokens() {
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        ScannerImpl scannerImpl = this;
        scannerImpl.unwindIndent(scannerImpl.reader.getColumn());
        int n2 = this.reader.peek();
        switch (n2) {
            case 0: {
                this.fetchStreamEnd();
                return;
            }
            case 37: {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case 45: {
                if (this.checkDocumentStart()) {
                    this.fetchDocumentStart();
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case 46: {
                if (!this.checkDocumentEnd()) break;
                this.fetchDocumentEnd();
                return;
            }
            case 91: {
                this.fetchFlowSequenceStart();
                return;
            }
            case 123: {
                this.fetchFlowMappingStart();
                return;
            }
            case 93: {
                this.fetchFlowSequenceEnd();
                return;
            }
            case 125: {
                this.fetchFlowMappingEnd();
                return;
            }
            case 44: {
                this.fetchFlowEntry();
                return;
            }
            case 63: {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case 58: {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case 42: {
                this.fetchAlias();
                return;
            }
            case 38: {
                this.fetchAnchor();
                return;
            }
            case 33: {
                this.fetchTag();
                return;
            }
            case 124: {
                if (this.flowLevel != 0) break;
                this.fetchLiteral();
                return;
            }
            case 62: {
                if (this.flowLevel != 0) break;
                this.fetchFolded();
                return;
            }
            case 39: {
                this.fetchSingle();
                return;
            }
            case 34: {
                this.fetchDouble();
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        String string = this.escapeChar(String.valueOf(Character.toChars(n2)));
        if (n2 == 9) {
            string = string + "(TAB)";
        }
        String string2 = String.format("found character '%s' that cannot start any token. (Do not use %s for indentation)", string, string);
        throw new ScannerException("while scanning for the next token", null, string2, this.reader.getMark());
    }

    private String escapeChar(String string) {
        for (Character c2 : ESCAPE_REPLACEMENTS.keySet()) {
            String string2 = ESCAPE_REPLACEMENTS.get(c2);
            if (!string2.equals(string)) continue;
            return "\\" + c2;
        }
        return string;
    }

    private int nextPossibleSimpleKey() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            return this.possibleSimpleKeys.values().iterator().next().getTokenNumber();
        }
        return -1;
    }

    private void stalePossibleSimpleKeys() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            Iterator<SimpleKey> iterator = this.possibleSimpleKeys.values().iterator();
            while (iterator.hasNext()) {
                SimpleKey simpleKey = iterator.next();
                if (simpleKey.getLine() == this.reader.getLine() && this.reader.getIndex() - simpleKey.getIndex() <= 1024) continue;
                if (simpleKey.isRequired()) {
                    throw new ScannerException("while scanning a simple key", simpleKey.getMark(), "could not find expected ':'", this.reader.getMark());
                }
                iterator.remove();
            }
        }
    }

    private void savePossibleSimpleKey() {
        boolean bl;
        boolean bl2 = bl = this.flowLevel == 0 && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && bl) {
            throw new YAMLException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            this.removePossibleSimpleKey();
            int n2 = this.tokensTaken + this.tokens.size();
            SimpleKey simpleKey = new SimpleKey(n2, bl, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), this.reader.getMark());
            this.possibleSimpleKeys.put(this.flowLevel, simpleKey);
        }
    }

    private void removePossibleSimpleKey() {
        SimpleKey simpleKey = this.possibleSimpleKeys.remove(this.flowLevel);
        if (simpleKey != null && simpleKey.isRequired()) {
            throw new ScannerException("while scanning a simple key", simpleKey.getMark(), "could not find expected ':'", this.reader.getMark());
        }
    }

    private void unwindIndent(int n2) {
        if (this.flowLevel != 0) {
            return;
        }
        while (this.indent > n2) {
            Mark mark = this.reader.getMark();
            this.indent = this.indents.pop();
            Mark mark2 = mark;
            this.addToken(new BlockEndToken(mark2, mark2));
        }
    }

    private boolean addIndent(int n2) {
        if (this.indent < n2) {
            this.indents.push(this.indent);
            this.indent = n2;
            return true;
        }
        return false;
    }

    private void fetchStreamStart() {
        Object object = this.reader.getMark();
        Mark mark = object;
        object = new StreamStartToken(mark, mark);
        this.addToken((Token)object);
    }

    private void fetchStreamEnd() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        Object object = this.reader.getMark();
        Mark mark = object;
        object = new StreamEndToken(mark, mark);
        this.addToken((Token)object);
        this.done = true;
    }

    private void fetchDirective() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        List<Token> list = this.scanDirective();
        this.addAllTokens(list);
    }

    private void fetchDocumentStart() {
        this.fetchDocumentIndicator(true);
    }

    private void fetchDocumentEnd() {
        this.fetchDocumentIndicator(false);
    }

    private void fetchDocumentIndicator(boolean bl) {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Mark mark = this.reader.getMark();
        this.reader.forward(3);
        Mark mark2 = this.reader.getMark();
        Token token = bl ? new DocumentStartToken(mark, mark2) : new DocumentEndToken(mark, mark2);
        this.addToken(token);
    }

    private void fetchFlowSequenceStart() {
        this.fetchFlowCollectionStart(false);
    }

    private void fetchFlowMappingStart() {
        this.fetchFlowCollectionStart(true);
    }

    private void fetchFlowCollectionStart(boolean bl) {
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        Mark mark = this.reader.getMark();
        this.reader.forward(1);
        Mark mark2 = this.reader.getMark();
        Token token = bl ? new FlowMappingStartToken(mark, mark2) : new FlowSequenceStartToken(mark, mark2);
        this.addToken(token);
    }

    private void fetchFlowSequenceEnd() {
        this.fetchFlowCollectionEnd(false);
    }

    private void fetchFlowMappingEnd() {
        this.fetchFlowCollectionEnd(true);
    }

    private void fetchFlowCollectionEnd(boolean bl) {
        this.removePossibleSimpleKey();
        --this.flowLevel;
        this.allowSimpleKey = false;
        Mark mark = this.reader.getMark();
        this.reader.forward();
        Mark mark2 = this.reader.getMark();
        Token token = bl ? new FlowMappingEndToken(mark, mark2) : new FlowSequenceEndToken(mark, mark2);
        this.addToken(token);
    }

    private void fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Object object = this.reader.getMark();
        this.reader.forward();
        Mark mark = this.reader.getMark();
        object = new FlowEntryToken((Mark)object, mark);
        this.addToken((Token)object);
    }

    private void fetchBlockEntry() {
        Object object;
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new ScannerException(null, null, "sequence entries are not allowed here", this.reader.getMark());
            }
            ScannerImpl scannerImpl = this;
            if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                object = this.reader.getMark();
                Mark mark = object;
                this.addToken(new BlockSequenceStartToken(mark, mark));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        object = this.reader.getMark();
        this.reader.forward();
        Mark mark = this.reader.getMark();
        object = new BlockEntryToken((Mark)object, mark);
        this.addToken((Token)object);
    }

    private void fetchKey() {
        Object object;
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new ScannerException(null, null, "mapping keys are not allowed here", this.reader.getMark());
            }
            ScannerImpl scannerImpl = this;
            if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                object = this.reader.getMark();
                Mark mark = object;
                this.addToken(new BlockMappingStartToken(mark, mark));
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.removePossibleSimpleKey();
        object = this.reader.getMark();
        this.reader.forward();
        Mark mark = this.reader.getMark();
        object = new KeyToken((Mark)object, mark);
        this.addToken((Token)object);
    }

    private void fetchValue() {
        Object object = this.possibleSimpleKeys.remove(this.flowLevel);
        if (object != null) {
            this.addToken(((SimpleKey)object).getTokenNumber() - this.tokensTaken, new KeyToken(((SimpleKey)object).getMark(), ((SimpleKey)object).getMark()));
            if (this.flowLevel == 0 && this.addIndent(((SimpleKey)object).getColumn())) {
                this.addToken(((SimpleKey)object).getTokenNumber() - this.tokensTaken, new BlockMappingStartToken(((SimpleKey)object).getMark(), ((SimpleKey)object).getMark()));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                throw new ScannerException(null, null, "mapping values are not allowed here", this.reader.getMark());
            }
            if (this.flowLevel == 0) {
                ScannerImpl scannerImpl = this;
                if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                    Object object2 = object = this.reader.getMark();
                    this.addToken(new BlockMappingStartToken((Mark)object2, (Mark)object2));
                }
            }
            this.allowSimpleKey = this.flowLevel == 0;
            this.removePossibleSimpleKey();
        }
        object = this.reader.getMark();
        this.reader.forward();
        Mark mark = this.reader.getMark();
        object = new ValueToken((Mark)object, mark);
        this.addToken((Token)object);
    }

    private void fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(false);
        this.addToken(token);
    }

    private void fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(true);
        this.addToken(token);
    }

    private void fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.addToken(token);
    }

    private void fetchLiteral() {
        this.fetchBlockScalar('|');
    }

    private void fetchFolded() {
        this.fetchBlockScalar('>');
    }

    private void fetchBlockScalar(char c2) {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        List<Token> list = this.scanBlockScalar(c2);
        this.addAllTokens(list);
    }

    private void fetchSingle() {
        this.fetchFlowScalar('\'');
    }

    private void fetchDouble() {
        this.fetchFlowScalar('\"');
    }

    private void fetchFlowScalar(char c2) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanFlowScalar(c2);
        this.addToken(token);
    }

    private void fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanPlain();
        this.addToken(token);
    }

    private boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private boolean checkDocumentStart() {
        return this.reader.getColumn() == 0 && "---".equals(this.reader.prefix(3)) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3));
    }

    private boolean checkDocumentEnd() {
        return this.reader.getColumn() == 0 && "...".equals(this.reader.prefix(3)) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3));
    }

    private boolean checkBlockEntry() {
        return Constant.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkKey() {
        if (this.flowLevel != 0) {
            return true;
        }
        return Constant.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkValue() {
        if (this.flowLevel != 0) {
            return true;
        }
        return Constant.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkPlain() {
        int n2 = this.reader.peek();
        return Constant.NULL_BL_T_LINEBR.hasNo(n2, "-?:,[]{}#&*!|>'\"%@`") || Constant.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1)) && (n2 == 45 || this.flowLevel == 0 && "?:".indexOf(n2) != -1);
    }

    private void scanToNextToken() {
        if (this.reader.getIndex() == 0 && this.reader.peek() == 65279) {
            this.reader.forward();
        }
        boolean bl = false;
        int n2 = -1;
        while (!bl) {
            String string;
            Object object;
            Mark mark = this.reader.getMark();
            int n3 = this.reader.getColumn();
            boolean bl2 = false;
            int n4 = 0;
            while (this.reader.peek(n4) == 32) {
                ++n4;
            }
            if (n4 > 0) {
                this.reader.forward(n4);
            }
            if (this.reader.peek() == 35) {
                CommentType commentType;
                bl2 = true;
                if (n3 != 0 && (this.lastToken == null || this.lastToken.getTokenId() != Token$ID.BlockEntry)) {
                    commentType = CommentType.IN_LINE;
                    n2 = this.reader.getColumn();
                } else if (n2 == this.reader.getColumn()) {
                    commentType = CommentType.IN_LINE;
                } else {
                    n2 = -1;
                    commentType = CommentType.BLOCK;
                }
                object = this.scanComment(commentType);
                if (this.parseComments) {
                    this.addToken((Token)object);
                }
            }
            if ((string = this.scanLineBreak()).length() != 0) {
                if (this.parseComments && !bl2 && n3 == 0) {
                    object = this.reader.getMark();
                    this.addToken(new CommentToken(CommentType.BLANK_LINE, string, mark, (Mark)object));
                }
                if (this.flowLevel != 0) continue;
                this.allowSimpleKey = true;
                continue;
            }
            bl = true;
        }
    }

    private CommentToken scanComment(CommentType commentType) {
        Mark mark = this.reader.getMark();
        this.reader.forward();
        int n2 = 0;
        while (Constant.NULL_OR_LINEBR.hasNo(this.reader.peek(n2))) {
            ++n2;
        }
        String string = this.reader.prefixForward(n2);
        Mark mark2 = this.reader.getMark();
        return new CommentToken(commentType, string, mark, mark2);
    }

    private List<Token> scanDirective() {
        Mark mark;
        Object object = this.reader.getMark();
        this.reader.forward();
        String string = this.scanDirectiveName((Mark)object);
        List<Object> list = null;
        if ("YAML".equals(string)) {
            list = this.scanYamlDirectiveValue((Mark)object);
            mark = this.reader.getMark();
        } else if ("TAG".equals(string)) {
            list = this.scanTagDirectiveValue((Mark)object);
            mark = this.reader.getMark();
        } else {
            mark = this.reader.getMark();
            int n2 = 0;
            while (Constant.NULL_OR_LINEBR.hasNo(this.reader.peek(n2))) {
                ++n2;
            }
            if (n2 > 0) {
                this.reader.forward(n2);
            }
        }
        CommentToken commentToken = this.scanDirectiveIgnoredLine((Mark)object);
        object = new DirectiveToken<Integer>(string, list, (Mark)object, mark);
        return this.makeTokenList(new Token[]{object, commentToken});
    }

    private String scanDirectiveName(Mark mark) {
        int n2 = 0;
        int n3 = this.reader.peek(0);
        while (Constant.ALPHA.has(n3)) {
            n3 = this.reader.peek(++n2);
        }
        if (n2 == 0) {
            String string = String.valueOf(Character.toChars(n3));
            throw new ScannerException("while scanning a directive", mark, "expected alphabetic or numeric character, but found " + string + "(" + n3 + ")", this.reader.getMark());
        }
        String string = this.reader.prefixForward(n2);
        n3 = this.reader.peek();
        if (Constant.NULL_BL_LINEBR.hasNo(n3)) {
            string = String.valueOf(Character.toChars(n3));
            throw new ScannerException("while scanning a directive", mark, "expected alphabetic or numeric character, but found " + string + "(" + n3 + ")", this.reader.getMark());
        }
        return string;
    }

    private List<Integer> scanYamlDirectiveValue(Mark mark) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        Integer n2 = this.scanYamlDirectiveNumber(mark);
        int n3 = this.reader.peek();
        if (n3 != 46) {
            String string = String.valueOf(Character.toChars(n3));
            throw new ScannerException("while scanning a directive", mark, "expected a digit or '.', but found " + string + "(" + n3 + ")", this.reader.getMark());
        }
        this.reader.forward();
        Integer n4 = this.scanYamlDirectiveNumber(mark);
        n3 = this.reader.peek();
        if (Constant.NULL_BL_LINEBR.hasNo(n3)) {
            String string = String.valueOf(Character.toChars(n3));
            throw new ScannerException("while scanning a directive", mark, "expected a digit or ' ', but found " + string + "(" + n3 + ")", this.reader.getMark());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(n2);
        arrayList.add(n4);
        return arrayList;
    }

    private Integer scanYamlDirectiveNumber(Mark serializable) {
        int n2 = this.reader.peek();
        if (!Character.isDigit(n2)) {
            String string = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a directive", (Mark)serializable, "expected a digit, but found " + string + "(" + n2 + ")", this.reader.getMark());
        }
        int n3 = 0;
        while (Character.isDigit(this.reader.peek(n3))) {
            ++n3;
        }
        serializable = Integer.valueOf(Integer.parseInt(this.reader.prefixForward(n3)));
        return serializable;
    }

    private List<String> scanTagDirectiveValue(Mark object) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        String string = this.scanTagDirectiveHandle((Mark)object);
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        object = this.scanTagDirectivePrefix((Mark)object);
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        arrayList.add((String)object);
        return arrayList;
    }

    private String scanTagDirectiveHandle(Mark mark) {
        String string = this.scanTagHandle("directive", mark);
        int n2 = this.reader.peek();
        if (n2 != 32) {
            string = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a directive", mark, "expected ' ', but found " + string + "(" + n2 + ")", this.reader.getMark());
        }
        return string;
    }

    private String scanTagDirectivePrefix(Mark mark) {
        String string = this.scanTagUri("directive", mark);
        int n2 = this.reader.peek();
        if (Constant.NULL_BL_LINEBR.hasNo(n2)) {
            string = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a directive", mark, "expected ' ', but found " + string + "(" + n2 + ")", this.reader.getMark());
        }
        return string;
    }

    private CommentToken scanDirectiveIgnoredLine(Mark mark) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        Object object = null;
        if (this.reader.peek() == 35) {
            CommentToken commentToken = this.scanComment(CommentType.IN_LINE);
            if (this.parseComments) {
                object = commentToken;
            }
        }
        int n2 = this.reader.peek();
        String string = this.scanLineBreak();
        if (string.length() == 0 && n2 != 0) {
            object = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a directive", mark, "expected a comment or a line break, but found " + (String)object + "(" + n2 + ")", this.reader.getMark());
        }
        return object;
    }

    private Token scanAnchor(boolean bl) {
        Mark mark = this.reader.getMark();
        int n2 = this.reader.peek();
        String string = n2 == 42 ? "alias" : "anchor";
        this.reader.forward();
        int n3 = 0;
        int n4 = this.reader.peek(0);
        while (Constant.NULL_BL_T_LINEBR.hasNo(n4, ":,[]{}/.*&")) {
            n4 = this.reader.peek(++n3);
        }
        if (n3 == 0) {
            String string2 = String.valueOf(Character.toChars(n4));
            throw new ScannerException("while scanning an " + string, mark, "unexpected character found " + string2 + "(" + n4 + ")", this.reader.getMark());
        }
        String string3 = this.reader.prefixForward(n3);
        n4 = this.reader.peek();
        if (Constant.NULL_BL_T_LINEBR.hasNo(n4, "?:,]}%@`")) {
            String string4 = String.valueOf(Character.toChars(n4));
            throw new ScannerException("while scanning an " + string, mark, "unexpected character found " + string4 + "(" + n4 + ")", this.reader.getMark());
        }
        Mark mark2 = this.reader.getMark();
        Token token = bl ? new AnchorToken(string3, mark, mark2) : new AliasToken(string3, mark, mark2);
        return token;
    }

    private Token scanTag() {
        Object object;
        Mark mark = this.reader.getMark();
        int n2 = this.reader.peek(1);
        Object object2 = null;
        if (n2 == 60) {
            this.reader.forward(2);
            object = this.scanTagUri("tag", mark);
            n2 = this.reader.peek();
            if (n2 != 62) {
                object2 = String.valueOf(Character.toChars(n2));
                throw new ScannerException("while scanning a tag", mark, "expected '>', but found '" + (String)object2 + "' (" + n2 + ")", this.reader.getMark());
            }
            this.reader.forward();
        } else if (Constant.NULL_BL_T_LINEBR.has(n2)) {
            object = "!";
            this.reader.forward();
        } else {
            int n3 = 1;
            boolean bl = false;
            while (Constant.NULL_BL_LINEBR.hasNo(n2)) {
                if (n2 == 33) {
                    bl = true;
                    break;
                }
                n2 = this.reader.peek(++n3);
            }
            if (bl) {
                object2 = this.scanTagHandle("tag", mark);
            } else {
                object2 = "!";
                this.reader.forward();
            }
            object = this.scanTagUri("tag", mark);
        }
        n2 = this.reader.peek();
        if (Constant.NULL_BL_LINEBR.hasNo(n2)) {
            object2 = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a tag", mark, "expected ' ', but found '" + (String)object2 + "' (" + n2 + ")", this.reader.getMark());
        }
        object2 = new TagTuple((String)object2, (String)object);
        object = this.reader.getMark();
        return new TagToken((TagTuple)object2, mark, (Mark)object);
    }

    private List<Token> scanBlockScalar(char c2) {
        Object object;
        int n2;
        String string;
        Object object2;
        boolean bl = c2 == '>';
        StringBuilder stringBuilder = new StringBuilder();
        Mark mark = this.reader.getMark();
        this.reader.forward();
        ScannerImpl$Chomping scannerImpl$Chomping = this.scanBlockScalarIndicators(mark);
        int n3 = scannerImpl$Chomping.getIncrement();
        CommentToken commentToken = this.scanBlockScalarIgnoredLine(mark);
        int n4 = this.indent + 1;
        if (n4 <= 0) {
            n4 = 1;
        }
        if (n3 == -1) {
            object2 = this.scanBlockScalarIndentation();
            string = (String)object2[0];
            n2 = (Integer)object2[1];
            object = (Object[])object2[2];
            n4 = Math.max(n4, n2);
        } else {
            n4 = n4 + n3 - 1;
            object2 = this.scanBlockScalarBreaks(n4);
            string = (String)object2[0];
            object = (Mark)object2[1];
        }
        object2 = "";
        while (this.reader.getColumn() == n4 && this.reader.peek() != 0) {
            stringBuilder.append(string);
            n2 = " \t".indexOf(this.reader.peek()) == -1 ? 1 : 0;
            int n5 = 0;
            while (Constant.NULL_OR_LINEBR.hasNo(this.reader.peek(n5))) {
                ++n5;
            }
            stringBuilder.append(this.reader.prefixForward(n5));
            object2 = this.scanLineBreak();
            object = this.scanBlockScalarBreaks(n4);
            string = (String)object[0];
            object = (Mark)object[1];
            if (this.reader.getColumn() != n4 || this.reader.peek() == 0) break;
            if (bl && "\n".equals(object2) && n2 != 0 && " \t".indexOf(this.reader.peek()) == -1) {
                if (string.length() != 0) continue;
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append((String)object2);
        }
        if (scannerImpl$Chomping.chompTailIsNotFalse()) {
            stringBuilder.append((String)object2);
        }
        if (scannerImpl$Chomping.chompTailIsTrue()) {
            stringBuilder.append(string);
        }
        ScalarToken scalarToken = new ScalarToken(stringBuilder.toString(), false, mark, (Mark)object, DumperOptions$ScalarStyle.createStyle(Character.valueOf(c2)));
        return this.makeTokenList(commentToken, scalarToken);
    }

    private ScannerImpl$Chomping scanBlockScalarIndicators(Mark mark) {
        Boolean bl = null;
        int n2 = -1;
        int n3 = this.reader.peek();
        if (n3 == 45 || n3 == 43) {
            bl = n3 == 43 ? Boolean.TRUE : Boolean.FALSE;
            this.reader.forward();
            n3 = this.reader.peek();
            if (Character.isDigit(n3)) {
                String string = String.valueOf(Character.toChars(n3));
                n2 = Integer.parseInt(string);
                if (n2 == 0) {
                    throw new ScannerException("while scanning a block scalar", mark, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark());
                }
                this.reader.forward();
            }
        } else if (Character.isDigit(n3)) {
            String string = String.valueOf(Character.toChars(n3));
            n2 = Integer.parseInt(string);
            if (n2 == 0) {
                throw new ScannerException("while scanning a block scalar", mark, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark());
            }
            this.reader.forward();
            n3 = this.reader.peek();
            if (n3 == 45 || n3 == 43) {
                bl = n3 == 43 ? Boolean.TRUE : Boolean.FALSE;
                this.reader.forward();
            }
        }
        if (Constant.NULL_BL_LINEBR.hasNo(n3 = this.reader.peek())) {
            String string = String.valueOf(Character.toChars(n3));
            throw new ScannerException("while scanning a block scalar", mark, "expected chomping or indentation indicators, but found " + string + "(" + n3 + ")", this.reader.getMark());
        }
        return new ScannerImpl$Chomping(bl, n2);
    }

    private CommentToken scanBlockScalarIgnoredLine(Mark mark) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        Object object = null;
        if (this.reader.peek() == 35) {
            object = this.scanComment(CommentType.IN_LINE);
        }
        int n2 = this.reader.peek();
        String string = this.scanLineBreak();
        if (string.length() == 0 && n2 != 0) {
            object = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a block scalar", mark, "expected a comment or a line break, but found " + (String)object + "(" + n2 + ")", this.reader.getMark());
        }
        return object;
    }

    private Object[] scanBlockScalarIndentation() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        Mark mark = this.reader.getMark();
        while (Constant.LINEBR.has(this.reader.peek(), " \r")) {
            if (this.reader.peek() != 32) {
                stringBuilder.append(this.scanLineBreak());
                mark = this.reader.getMark();
                continue;
            }
            this.reader.forward();
            if (this.reader.getColumn() <= n2) continue;
            n2 = this.reader.getColumn();
        }
        return new Object[]{stringBuilder.toString(), n2, mark};
    }

    private Object[] scanBlockScalarBreaks(int n2) {
        String string;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        Mark mark = this.reader.getMark();
        for (n3 = this.reader.getColumn(); n3 < n2 && this.reader.peek() == 32; ++n3) {
            this.reader.forward();
        }
        while ((string = this.scanLineBreak()).length() != 0) {
            stringBuilder.append(string);
            mark = this.reader.getMark();
            for (n3 = this.reader.getColumn(); n3 < n2 && this.reader.peek() == 32; ++n3) {
                this.reader.forward();
            }
        }
        return new Object[]{stringBuilder.toString(), mark};
    }

    private Token scanFlowScalar(char c2) {
        boolean bl = c2 == '\"';
        StringBuilder stringBuilder = new StringBuilder();
        Mark mark = this.reader.getMark();
        int n2 = this.reader.peek();
        this.reader.forward();
        stringBuilder.append(this.scanFlowScalarNonSpaces(bl, mark));
        while (this.reader.peek() != n2) {
            stringBuilder.append(this.scanFlowScalarSpaces(mark));
            stringBuilder.append(this.scanFlowScalarNonSpaces(bl, mark));
        }
        this.reader.forward();
        Mark mark2 = this.reader.getMark();
        return new ScalarToken(stringBuilder.toString(), false, mark, mark2, DumperOptions$ScalarStyle.createStyle(Character.valueOf(c2)));
    }

    private String scanFlowScalarNonSpaces(boolean bl, Mark mark) {
        StringBuilder stringBuilder;
        block8: {
            String string;
            int n2;
            stringBuilder = new StringBuilder();
            while (true) {
                n2 = 0;
                while (Constant.NULL_BL_T_LINEBR.hasNo(this.reader.peek(n2), "'\"\\")) {
                    ++n2;
                }
                if (n2 != 0) {
                    stringBuilder.append(this.reader.prefixForward(n2));
                }
                n2 = this.reader.peek();
                if (!bl && n2 == 39 && this.reader.peek(1) == 39) {
                    stringBuilder.append("'");
                    this.reader.forward(2);
                    continue;
                }
                if (bl && n2 == 39 || !bl && "\"\\".indexOf(n2) != -1) {
                    stringBuilder.appendCodePoint(n2);
                    this.reader.forward();
                    continue;
                }
                if (!bl || n2 != 92) break block8;
                this.reader.forward();
                n2 = this.reader.peek();
                if (!Character.isSupplementaryCodePoint(n2) && ESCAPE_REPLACEMENTS.containsKey(Character.valueOf((char)n2))) {
                    stringBuilder.append(ESCAPE_REPLACEMENTS.get(Character.valueOf((char)n2)));
                    this.reader.forward();
                    continue;
                }
                if (!Character.isSupplementaryCodePoint(n2) && ESCAPE_CODES.containsKey(Character.valueOf((char)n2))) {
                    n2 = ESCAPE_CODES.get(Character.valueOf((char)n2));
                    this.reader.forward();
                    string = this.reader.prefix(n2);
                    if (NOT_HEXA.matcher(string).find()) {
                        throw new ScannerException("while scanning a double-quoted scalar", mark, "expected escape sequence of " + n2 + " hexadecimal numbers, but found: " + string, this.reader.getMark());
                    }
                    int n3 = Integer.parseInt(string, 16);
                    string = new String(Character.toChars(n3));
                    stringBuilder.append(string);
                    this.reader.forward(n2);
                    continue;
                }
                if (this.scanLineBreak().length() == 0) break;
                stringBuilder.append(this.scanFlowScalarBreaks(mark));
            }
            string = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a double-quoted scalar", mark, "found unknown escape character " + string + "(" + n2 + ")", this.reader.getMark());
        }
        return stringBuilder.toString();
    }

    private String scanFlowScalarSpaces(Mark object) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (" \t".indexOf(this.reader.peek(n2)) != -1) {
            ++n2;
        }
        String string = this.reader.prefixForward(n2);
        int n3 = this.reader.peek();
        if (n3 == 0) {
            throw new ScannerException("while scanning a quoted scalar", (Mark)object, "found unexpected end of stream", this.reader.getMark());
        }
        String string2 = this.scanLineBreak();
        if (string2.length() != 0) {
            object = this.scanFlowScalarBreaks((Mark)object);
            if (!"\n".equals(string2)) {
                stringBuilder.append(string2);
            } else if (((String)object).length() == 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append((String)object);
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String scanFlowScalarBreaks(Mark mark) {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            String string;
            if (("---".equals(string = this.reader.prefix(3)) || "...".equals(string)) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                throw new ScannerException("while scanning a quoted scalar", mark, "found unexpected document separator", this.reader.getMark());
            }
            while (" \t".indexOf(this.reader.peek()) != -1) {
                this.reader.forward();
            }
            string = this.scanLineBreak();
            if (string.length() == 0) break;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private Token scanPlain() {
        Mark mark;
        StringBuilder stringBuilder = new StringBuilder();
        Mark mark2 = mark = this.reader.getMark();
        int n2 = this.indent + 1;
        String string = "";
        do {
            int n3;
            int n4 = 0;
            if (this.reader.peek() == 35) break;
            while (!(Constant.NULL_BL_T_LINEBR.has(n3 = this.reader.peek(n4)) || n3 == 58 && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(n4 + 1), this.flowLevel != 0 ? ",[]{}" : "") || this.flowLevel != 0 && ",?[]{}".indexOf(n3) != -1)) {
                ++n4;
            }
            if (n4 == 0) break;
            this.allowSimpleKey = false;
            stringBuilder.append(string);
            stringBuilder.append(this.reader.prefixForward(n4));
            mark2 = this.reader.getMark();
            string = this.scanPlainSpaces();
        } while (string.length() != 0 && this.reader.peek() != 35 && (this.flowLevel != 0 || this.reader.getColumn() >= n2));
        return new ScalarToken(stringBuilder.toString(), mark, mark2, true);
    }

    private boolean atEndOfPlain() {
        int n2;
        int n3 = 0;
        int n4 = this.reader.getColumn();
        while ((n2 = this.reader.peek(n3)) != 0 && Constant.NULL_BL_T_LINEBR.has(n2)) {
            if (!(Constant.LINEBR.has(n2) || n2 == 13 && this.reader.peek(++n3 + 1) == 10 || n2 == 65279)) {
                ++n4;
                continue;
            }
            n4 = 0;
        }
        if (this.reader.peek(n3) == 35 || this.reader.peek(n3 + 1) == 0 || this.flowLevel == 0 && n4 < this.indent) {
            return true;
        }
        if (this.flowLevel == 0) {
            n4 = 1;
            while ((n2 = this.reader.peek(n3 + n4)) != 0 && !Constant.NULL_BL_T_LINEBR.has(n2)) {
                if (n2 == 58 && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(n3 + n4 + 1))) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    private String scanPlainSpaces() {
        int n2 = 0;
        while (this.reader.peek(n2) == 32 || this.reader.peek(n2) == 9) {
            ++n2;
        }
        String string = this.reader.prefixForward(n2);
        String string2 = this.scanLineBreak();
        if (string2.length() != 0) {
            StringBuilder stringBuilder;
            block8: {
                this.allowSimpleKey = true;
                string = this.reader.prefix(3);
                if ("---".equals(string) || "...".equals(string) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                    return "";
                }
                if (this.parseComments && this.atEndOfPlain()) {
                    return "";
                }
                stringBuilder = new StringBuilder();
                while (true) {
                    if (this.reader.peek() == 32) {
                        this.reader.forward();
                        continue;
                    }
                    string = this.scanLineBreak();
                    if (string.length() == 0) break block8;
                    stringBuilder.append(string);
                    string = this.reader.prefix(3);
                    if ("---".equals(string) || "...".equals(string) && Constant.NULL_BL_T_LINEBR.has(this.reader.peek(3))) break;
                }
                return "";
            }
            if (!"\n".equals(string2)) {
                return string2 + stringBuilder;
            }
            if (stringBuilder.length() == 0) {
                return " ";
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private String scanTagHandle(String string, Mark mark) {
        int n2 = this.reader.peek();
        if (n2 != 33) {
            String string2 = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a " + string, mark, "expected '!', but found " + string2 + "(" + n2 + ")", this.reader.getMark());
        }
        int n3 = 1;
        n2 = this.reader.peek(1);
        if (n2 != 32) {
            while (Constant.ALPHA.has(n2)) {
                n2 = this.reader.peek(++n3);
            }
            if (n2 != 33) {
                this.reader.forward(n3);
                String string3 = String.valueOf(Character.toChars(n2));
                throw new ScannerException("while scanning a " + string, mark, "expected '!', but found " + string3 + "(" + n2 + ")", this.reader.getMark());
            }
            ++n3;
        }
        String string4 = this.reader.prefixForward(n3);
        return string4;
    }

    private String scanTagUri(String string, Mark mark) {
        CharSequence charSequence = new StringBuilder();
        int n2 = 0;
        int n3 = this.reader.peek(0);
        while (Constant.URI_CHARS.has(n3)) {
            if (n3 == 37) {
                ((StringBuilder)charSequence).append(this.reader.prefixForward(n2));
                n2 = 0;
                ((StringBuilder)charSequence).append(this.scanUriEscapes(string, mark));
            } else {
                ++n2;
            }
            n3 = this.reader.peek(n2);
        }
        if (n2 != 0) {
            ((StringBuilder)charSequence).append(this.reader.prefixForward(n2));
        }
        if (((StringBuilder)charSequence).length() == 0) {
            charSequence = String.valueOf(Character.toChars(n3));
            throw new ScannerException("while scanning a " + string, mark, "expected URI, but found " + (String)charSequence + "(" + n3 + ")", this.reader.getMark());
        }
        return ((StringBuilder)charSequence).toString();
    }

    private String scanUriEscapes(String string, Mark mark) {
        int n2 = 1;
        while (this.reader.peek(n2 * 3) == 37) {
            ++n2;
        }
        Object object = this.reader.getMark();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        while (this.reader.peek() == 37) {
            int n3;
            this.reader.forward();
            try {
                n3 = Integer.parseInt(this.reader.prefix(2), 16);
                byteBuffer.put((byte)n3);
            }
            catch (NumberFormatException numberFormatException) {
                int n4 = this.reader.peek();
                object = String.valueOf(Character.toChars(n4));
                n3 = this.reader.peek(1);
                String string2 = String.valueOf(Character.toChars(n3));
                throw new ScannerException("while scanning a " + string, mark, "expected URI escape sequence of 2 hexadecimal numbers, but found " + (String)object + "(" + n4 + ") and " + string2 + "(" + n3 + ")", this.reader.getMark());
            }
            this.reader.forward(2);
        }
        byteBuffer.flip();
        try {
            return UriEncoder.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new ScannerException("while scanning a " + string, mark, "expected URI in UTF-8: " + characterCodingException.getMessage(), (Mark)object);
        }
    }

    private String scanLineBreak() {
        int n2 = this.reader.peek();
        if (n2 == 13 || n2 == 10 || n2 == 133) {
            if (n2 == 13 && 10 == this.reader.peek(1)) {
                this.reader.forward(2);
            } else {
                this.reader.forward();
            }
            return "\n";
        }
        if (n2 == 8232 || n2 == 8233) {
            this.reader.forward();
            return String.valueOf(Character.toChars(n2));
        }
        return "";
    }

    private List<Token> makeTokenList(Token ... tokenArray) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i2 = 0; i2 < tokenArray.length; ++i2) {
            if (tokenArray[i2] == null || !this.parseComments && tokenArray[i2] instanceof CommentToken) continue;
            arrayList.add(tokenArray[i2]);
        }
        return arrayList;
    }

    static {
        ESCAPE_REPLACEMENTS.put(Character.valueOf('0'), "\u0000");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('a'), "\u0007");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('b'), "\b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('t'), "\t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('n'), "\n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('v'), "\u000b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('f'), "\f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('r'), "\r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('e'), "\u001b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf(' '), " ");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('N'), "\u0085");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('_'), "\u00a0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('L'), "\u2028");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('P'), "\u2029");
        ESCAPE_CODES.put(Character.valueOf('x'), 2);
        ESCAPE_CODES.put(Character.valueOf('u'), 4);
        ESCAPE_CODES.put(Character.valueOf('U'), 8);
    }
}

