/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.serializer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.DumperOptions$Version;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CommentEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.nodes.AnchorNode;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.AnchorGenerator;
import org.yaml.snakeyaml.serializer.SerializerException;

public final class Serializer {
    private final Emitable emitter;
    private final Resolver resolver;
    private boolean explicitStart;
    private boolean explicitEnd;
    private DumperOptions$Version useVersion;
    private Map<String, String> useTags;
    private Set<Node> serializedNodes;
    private Map<Node, String> anchors;
    private AnchorGenerator anchorGenerator;
    private Boolean closed;
    private Tag explicitRoot;

    public Serializer(Emitable emitable, Resolver resolver, DumperOptions dumperOptions, Tag tag) {
        this.emitter = emitable;
        this.resolver = resolver;
        this.explicitStart = dumperOptions.isExplicitStart();
        this.explicitEnd = dumperOptions.isExplicitEnd();
        if (dumperOptions.getVersion() != null) {
            this.useVersion = dumperOptions.getVersion();
        }
        this.useTags = dumperOptions.getTags();
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, String>();
        this.anchorGenerator = dumperOptions.getAnchorGenerator();
        this.closed = null;
        this.explicitRoot = tag;
    }

    public final void open() {
        if (this.closed == null) {
            this.emitter.emit(new StreamStartEvent(null, null));
            this.closed = Boolean.FALSE;
            return;
        }
        if (Boolean.TRUE.equals(this.closed)) {
            throw new SerializerException("serializer is closed");
        }
        throw new SerializerException("serializer is already opened");
    }

    public final void close() {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (!Boolean.TRUE.equals(this.closed)) {
            this.emitter.emit(new StreamEndEvent(null, null));
            this.closed = Boolean.TRUE;
            this.serializedNodes.clear();
            this.anchors.clear();
        }
    }

    public final void serialize(Node node) {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed.booleanValue()) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(null, null, this.explicitStart, this.useVersion, this.useTags));
        this.anchorNode(node);
        if (this.explicitRoot != null) {
            node.setTag(this.explicitRoot);
        }
        this.serializeNode(node, null);
        this.emitter.emit(new DocumentEndEvent(null, null, this.explicitEnd));
        this.serializedNodes.clear();
        this.anchors.clear();
    }

    private void anchorNode(Node iterator) {
        if (((Node)((Object)iterator)).getNodeId() == NodeId.anchor) {
            iterator = ((AnchorNode)((Object)iterator)).getRealNode();
        }
        if (this.anchors.containsKey(iterator)) {
            String string = this.anchors.get(iterator);
            if (string == null) {
                string = this.anchorGenerator.nextAnchor((Node)((Object)iterator));
                this.anchors.put((Node)((Object)iterator), string);
            }
            return;
        }
        Node node = iterator;
        this.anchors.put(node, node.getAnchor() != null ? this.anchorGenerator.nextAnchor((Node)((Object)iterator)) : null);
        switch (((Node)((Object)iterator)).getNodeId()) {
            case sequence: {
                Node node2 = (SequenceNode)((Object)iterator);
                iterator = ((CollectionNode)node2).getValue();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    node2 = (Node)iterator.next();
                    this.anchorNode(node2);
                }
                return;
            }
            case mapping: {
                iterator = (MappingNode)((Object)iterator);
                Object object = ((CollectionNode)((Object)iterator)).getValue();
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = (NodeTuple)iterator.next();
                    Node node3 = ((NodeTuple)object).getKeyNode();
                    object = ((NodeTuple)object).getValueNode();
                    this.anchorNode(node3);
                    this.anchorNode((Node)object);
                }
                break;
            }
        }
    }

    private void serializeNode(Node node, Node object) {
        if (node.getNodeId() == NodeId.anchor) {
            node = ((AnchorNode)node).getRealNode();
        }
        object = this.anchors.get(node);
        if (this.serializedNodes.contains(node)) {
            this.emitter.emit(new AliasEvent((String)object, null, null));
            return;
        }
        this.serializedNodes.add(node);
        switch (node.getNodeId()) {
            case scalar: {
                ScalarNode scalarNode = (ScalarNode)node;
                this.serializeComments(node.getBlockComments());
                Object object2 = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), true);
                Tag tag = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), false);
                object2 = new ImplicitTuple(node.getTag().equals(object2), node.getTag().equals(tag));
                object = new ScalarEvent((String)object, node.getTag().getValue(), (ImplicitTuple)object2, scalarNode.getValue(), null, null, scalarNode.getScalarStyle());
                this.emitter.emit((Event)object);
                this.serializeComments(node.getInLineComments());
                this.serializeComments(node.getEndComments());
                return;
            }
            case sequence: {
                Object object3 = (SequenceNode)node;
                this.serializeComments(node.getBlockComments());
                boolean bl = node.getTag().equals(this.resolver.resolve(NodeId.sequence, null, true));
                this.emitter.emit(new SequenceStartEvent((String)object, node.getTag().getValue(), bl, null, null, ((CollectionNode)object3).getFlowStyle()));
                object = ((CollectionNode)object3).getValue();
                object3 = object.iterator();
                while (object3.hasNext()) {
                    Node node2 = (Node)object3.next();
                    this.serializeNode(node2, node);
                }
                this.emitter.emit(new SequenceEndEvent(null, null));
                this.serializeComments(node.getInLineComments());
                this.serializeComments(node.getEndComments());
                return;
            }
        }
        this.serializeComments(node.getBlockComments());
        Object object4 = this.resolver.resolve(NodeId.mapping, null, true);
        boolean bl = node.getTag().equals(object4);
        object4 = (MappingNode)node;
        Object object5 = ((CollectionNode)object4).getValue();
        if (((Node)object4).getTag() != Tag.COMMENT) {
            this.emitter.emit(new MappingStartEvent((String)object, ((Node)object4).getTag().getValue(), bl, null, null, ((CollectionNode)object4).getFlowStyle()));
            object = object5.iterator();
            while (object.hasNext()) {
                Object object6 = (NodeTuple)object.next();
                object5 = ((NodeTuple)object6).getKeyNode();
                object6 = ((NodeTuple)object6).getValueNode();
                this.serializeNode((Node)object5, (Node)object4);
                this.serializeNode((Node)object6, (Node)object4);
            }
            this.emitter.emit(new MappingEndEvent(null, null));
            this.serializeComments(node.getInLineComments());
            this.serializeComments(node.getEndComments());
        }
    }

    private void serializeComments(List<CommentLine> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (CommentLine)object.next();
            object2 = new CommentEvent(((CommentLine)object2).getCommentType(), ((CommentLine)object2).getValue(), ((CommentLine)object2).getStartMark(), ((CommentLine)object2).getEndMark());
            this.emitter.emit((Event)object2);
        }
    }
}

